/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* client.h - VGTS Client multiplexor data structures
 *
 * Needs to have Vioprotocol defined first.
 *
 * Bill Nowicki April 1983
 *
 * Marvin Theimer, 6/83
 *	Added termPid to the ExecDescriptor structure.
 * Marvin Theimer, 7/83
 *	Removed cmdPid from the ExecDescriptor structure and made termPid
 *	now represent the break process set by SET_BREAK_PROCESS.
 * Tim Mann, 8/6/83
 *	Added a per-process area to the ExecDescriptor.
 */


# define TRUE 1
# define FALSE 0
# define BlockSize 512		/* buffer size for writes to a VGT */
# define MaxClients 16		/* Max clients that the vgts can handle. */
# define MaxEvents 32		/* Max number of queued events */
# define DirectoryInstance (MaxClients-1)
				/* special instance ID for directory I/O */
# define LineBufferSize 256	/* maximum characters in a "line" */

struct Buffer
  {
  	/*
	 * temporary line buffer
	 */
    short count;		/* number of valid chars */
    short column;		/* current column */
    short escapeMode;		/* escape character */
    char c[LineBufferSize];	/* actual line buffer */
  };

struct Event
  {
    struct Event *next;		/* link */
    struct Event *editPrev;	/* backward link */
    short requestcode, fileid;	/* for compatibility */
    short code;			/* kind of event */
    short x, y, buttons;	/* for mouse events - otherwise fileid etc. */
    char shortbuffer[IO_MSG_BUFFER];
    unsigned bytecount;		/* number of chars in the buffer */
  } 
    EventTable[MaxEvents];


struct Client
	/*
	 * Descriptor for an applications client.  Contains queues
	 * of input characters and mouse
	 * clicks and flags for indicating the state of a client's
	 *  requests. 
	 */
  {
    int interp;			/* really a pointer to interp structure */
    ProcessId pid;		/* Process id of the client reading */
    ProcessId owner;		/* Delete it when this guy dies */
    ProcessId termPid;		/* pid of process to destroy on break input. */
    int requestFlag;		/* see bit definitions below */
    struct Event *eventQ;	/* event queue */
    struct Event *eventTail;
    struct Buffer *lineEditBuf;
    struct ExecDescriptor *exec;/* If there is an exec in the VGT */
    short vgt;			/* pad for input to go to */
    short master;		/* master vgt if we are a slave */
    int block;			/* "block" for Vio protocol */
    int mode;			/* mode bits (echo etc.) */
  };

	/*
	 * fillers for requestFlag of each client.
	 * The BlockBits are true if the pid is blocked awaiting
	 * reply on the given type of event.  
	 * SlaveReq means the client wants the first mouse event
	 * converted into characters.
	 */
# define Keyreq		1
# define Mousereq	2
# define BlockBits 	(Keyreq|Mousereq)
# define SlaveReq	4

/*
 * special End-of-file event code
 */

# define EOFcode 0x8000

enum MessageKind
  { 
  	Timer, 			/* a timer for blinking the cursor */
	Keyboard, 		/* a character was typed */
	GraphicsHelperMsg	/* contains a grpahics event */
  };


struct Client ClientTable[MaxClients];	/* the client table */

	/*
	 * size of the executive's stack
	 */
# define MainSize 2000		/* 2000 works */

struct ExecDescriptor
  {
  	/*
	 * this structure is allocated for each Executive,
	 * and gives the details for each one.
	 */
    ProcessId execPid;		/* pid of exec if any */
    File in, out;		/* Files used by the exec */
    unsigned char inbuffer[IO_MSG_BUFFER]; 
    unsigned char outbuffer[BlockSize];	/* buffers used by the files */
    PerProcessArea perProcess;	/* per-process area, must immediately
    				 * precede stack */
    char stack[MainSize];	/* stack for the exec */
  };

extern ProcessId VgtsPid;
