/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 *
 * UNIX password and group name lookup routines.  They are more
 * efficient than their UNIX counter-parts.
 */

#include <grp.h>

char *GetUnixGroupName( gid )
    register int gid;
/*
 * Find the name associated with this group id.
 * NOTE: caching may cause incorrect values to be returned, but
 * 	 this event is so rare that we will ignore it.
 */
  {
	register struct group *p;
	static char GroupName[ 9 ] = { 0 };
	static int LastGid = -1;
	struct group *getgrent();

	if ( LastGid == gid )
	  {
	    return( GroupName );
	  }
	setgrent();
 	do
	  {
	    if ( ( p = getgrent() ) == 0 )
	      return( 0 );
	  }
	while( p->gr_gid != gid );
	
	LastGid = gid;
	/* this is really a hack, but it is much faster than anything else */
	/* and it works only because we know that the length of the names
	   is 8 */
	((double*)GroupName)[ 0 ] = ((double*)(p->gr_name))[ 0 ];
	return( GroupName );

  } /* GetUnixGroupName */

#include <pwd.h>


char *GetUnixUserName( uid )
    register int uid;
  {
	register struct passwd *p;
	static char UserName[ 9 ] = { 0 };
	static int LastUid = -1;
	struct passwd *getpwent();

	if ( LastUid == uid )
	  {
	    return( UserName );
	  }
	setpwent();
 	do
	  {
	    if ( ( p = getpwent() ) == 0 )
	      return( 0 );
	  }
	while( p->pw_uid != uid );
	
	LastUid = uid;
	/* this is really a hack, but it is much faster than anything else */
	/* and it works only because we know that the length of the names
	   is 8 */
	((double*)UserName)[ 0 ] = ((double*)(p->pw_name))[ 0 ];
	return( UserName );

  } /* GetUnixUserName */
