/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * header file.
 * NOTE: that the "Instance" structures all start with the same structure
 *	 and the type specific information is appended to the end.
 * 	 FileInstance is the template for the first part.
 */


/* Use these to move long words with word reversal */
#define SPtr(k) ((short *)&(k))
#define CPtr(k)	((char *)&(k))
#define MoveLong(x,y) {*SPtr(y) = *(SPtr(x)+1); *(SPtr(y)+1) = *SPtr(x);}
#define MoveShort(x,y) {*CPtr(y) = *(CPtr(x)+1); *(CPtr(y)+1) = *CPtr(x);}
#define RealMoveLong(x,y) 	\
	{			\
	  CPtr(y)[0] = CPtr(x)[3];  CPtr(y)[1] = CPtr(x)[2]; \
	  CPtr(y)[2] = CPtr(x)[1];  CPtr(y)[3] = CPtr(x)[0]; \
	} 

#define MakeLong(x) ( ((x>>16)&0xFFFF) + (x<<16) )
#define RealMakeLong(x)		\
     ( ((((unsigned)(x)) >> 24) & 0xFF) + ((((unsigned)(x)) >> 8) & 0xFF00) \
       + ((((unsigned)(x)) << 8) & 0xFF0000) + (((unsigned)(x)) << 24) )

#define BLOCK_SIZE    1024	/* Efficient amount to read and write */
#define BUFFER_SIZE	4096	/* Max amount to read, write or MoveTo or From */
#define MAX_BYTES_IN_PIPE	4096	/* how much pipe holds before blocking */
#define MAX_PROG_ARGC		128	/* Random number of arguments to allow*/
					/* in remote execution of program */
#define MAX_PROG_NAME_LEN	128	/* Length of file name to be executed */
#define MAX_PROG_ARGS_LEN	512	/* Max length of args field in program*/
					/* execution request */

typedef short unsigned		InstanceType;
#define FILE_INSTANCE		0x0001
#define PROCESS_INSTANCE	0x0002
#define SESSION_INSTANCE	0x0003
#define DIRECTORY_INSTANCE	0x0004

struct _FI
  {
    struct _FI		*link;
    InstanceId		id;		/* File instance id */
    InstanceType	type;		/* FILE_INSTANCE */
    ProcessId		owner;		/* Owner process */
    char		*name;		/* full name of file */
    short unsigned	filetype;
    unsigned		lastblock;      /* Last block written */
    unsigned		nextblock;      /* Next block to be read */
    unsigned		blocksize;	/* Max. block size */
    short unsigned	lastbytes;
    int			unixfile;	/* returned by UNIX open or creat */
  };

typedef struct _FI FileInstance;

/*
 * Process may have two instance descriptors that contain info about them.
 * One for writing and the other for reading.  In this case,
 * the 'state' of the process must be updated in both PD's when
 * a change occurs [see CheckProcesses].
 */
struct _PD
  {
    struct _PD		*link;		
    InstanceId		id;		/* Process instance id */
    InstanceType	type;		/* PROCESS_INSTANCE */
    ProcessId		owner;		/* Owner of this process */
    char		*name;		/* name of file running */
    short unsigned	filetype;	/* Type of process communication */
    unsigned		lastblock;      /* Last block written */
    unsigned		nextblock;      /* Next block to be read */
    unsigned		blocksize;	/* Max block size */
    short unsigned	lastbytes;
    ProcessId		pid;		/* UNIX process id */
    short unsigned	state;		/* Server's idea of the process state */
    unsigned		pipedesc;	/* UNIX fid for pipe to process */
    SystemCode		lastreply;	/* last reply to a Read or Write */
    char		*lastdata;	/* last data Read */
    unsigned long	lastdatasize;	/* number of bytes in last data */
  };

typedef struct _PD ProcessInstance;

/* _PD.state codes */
#define	PD_RUNNING		0x0001
#define PD_DEAD			0x0002
#define PD_STOPPED		0x0003
#define PD_KILLED		0x0004
#define PD_AWAITING_DEATH	0x0005
 
/* Sessions have one instance descriptor that contains information
   specific to itself. */

struct _SD
  {
    struct _SD		*link;		
    InstanceId		id;		/* Session instance id */
    InstanceType	type;		/* SESSION_INSTANCE */
    ProcessId		owner;		/* Owner of this session */
    char 		*name;		/* NULL in this case */
    short unsigned	filetype;	
    unsigned		lastblock;
    unsigned		nextblock;
    unsigned		blocksize;
    short unsigned	lastbytes;
/* NOTE: the following field must be in the same place as _DI->pid 
  	 we use this in when a session dies */
    ProcessId		unixpid;	/* UNIX process id for the session */
    ProcessId		Vpid;		/* V process id for the session */
    int			debugfile;	/* returned by UNIX open or creat */
    int			uid;		/* user id of owner */
    int			gid;		/* group id of owner */
    long		logintime;	/* time of creation */
    int			timeout;	/* For timing out session */
    int			inactivity;	/* Inactivity count, for terminating
					 * session even if loginpid exists */
  };

typedef struct _SD SessionDesc;
extern SessionDesc *Session;
#define Unauthorized( pid ) ( Session->owner&0xFFFF0000 != pid&0xFFFF0000)

struct _DI
  {
    struct _DI		*link;
    InstanceId		id;		/* File instance id */
    InstanceType	type;		/* FILE_INSTANCE */
    ProcessId		owner;		/* Owner process */
    char		*name;		/* name is a ptr to context name;
    					   thus, it should not be freed */
    short unsigned	filetype;
    unsigned		lastblock;      /* Last block written */
    unsigned		nextblock;      /* Next block to be read */
    unsigned		blocksize;	/* Max. block size */
    short unsigned	lastbytes;
    int			unixfile;	/* returned by UNIX open or creat */
    ContextId		contextid;	/* ContextId of directory */
  };

typedef struct _DI DirectoryInstance;


struct _QIO
  {
    struct _QIO		*link;
    IoRequest		req;			/* Request pending */
    ProcessId		pid;			/* Requesting process */
    SystemCode		(*IOFunction)();	/* Function corresponding to
						    requestcode of 'req' */
  };

typedef struct _QIO	WaitingIOEntry;
