/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * Kernel (simulator) header file.
 */
#ifdef ENET3MEG

typedef struct
  {
    NetAddress		srchost;
    NetAddress		dsthost;
    unsigned short	packettype;
  } NetworkHeader;

/* No NetworkTrailer */
#endif

#ifdef ENET10MEG
/*
typedef struct
  {
    unsigned short	addrhigh,
    			addrmid,
			addrlow;
  } NetAddress;
 */

typedef struct
  {
    NetAddress		dsthost;
    NetAddress		srchost;
    unsigned short	packettype;
  } NetworkHeader;

/* No NetworkTrailer */
#endif ENET10MEG

struct KernelPacket
  {
    NetworkHeader	netheader;	/* Network-specific header */
    kPacketWithSegment	kernelpacket;	/* V portion of packet */
  };

struct SmallKernelPacket
  {
    NetworkHeader	netheader;	/* Network-specific header */
    kPacket		kernelpacket;	/* V portion of packet w/o segment */
  };
