/*
 * Unix V file server naming protocol 
 */

struct _CN
  {
    struct _CN	*left,*right;	/* tree structure (left is less than right) */
    ContextId	contextid;	/* index into tree */
    char	*name;		/* name of context (starts/ends with a '/') */
  };

typedef struct _CN	ContextNode;	

/* used to construct a ContextId from inode and device numbers.
   Also guarranteeing that it won't conflict with well know context ids */
#define ConsContextId( device, inode ) \
	((ContextId)(((((unsigned short)(device))<<(sizeof(unsigned short)*8)) \
	  + ((unsigned short)(inode))) | 0x80000000 ))
