/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * Kernel (simulator) header file.
 */

#define MAX_LOGICAL_ID 20
#define MOVE_TO_OP	1
#define MOVE_FROM_OP	2
#define VALID_PID_OP	3

#define SMALL_KPACKET sizeof(struct SmallKernelPacket) /* length of packet less data */

#define LOCAL_KERNEL_PROCESS_PID 0x4000
#define MAIN_SERVER_PID	0x20

/* Flags used by the alarm */

#define REPEAT 0
#define DONE 1
#define RETRANSMIT 2
#define NACKED 3


/* Use these to move long words with word reversal */
#define SPtr(k) ((short *)&(k))
#define MoveLong(x,y) {*SPtr(y) = *(SPtr(x)+1); *(SPtr(y)+1) = *SPtr(x);}

struct SendRecord
  { 
    struct SendRecord *next;	/* next message in queue of messages */
    ProcessId srcpid;		/* Pid of sending process */
    ProcessId dstpid;		/* destination process: KERNEL or MyPid */
    ProcessId forwarder;	/* Pid of the forwarding process */
    short sequenceNo;		/* Sequence number of this message */
    Message msg;	  	/* Message send */
  };




