#! /bin/csh -f
# Creates the storage server host table file for SIMPLELOOKUP mode
# of the server. 

# Uses internet lookup to make logical host id for all hosts specified
# in the argument list.
# The "host" program prints entries of the form:
# "Diablo HNV SU-HNV-hpp-ng-vax:36.40.0.193 TCP/FTP UDP hostcap=0"

# and the awk script converts the entry to:
# "Diablo	c1000000"
# "HNV	c1000000"
# "SU-HNV-hpp-ng-vax	c1000000"
#

cat << "END"
# This file was created by hosttab.csh.
# It contains a list of the host machines that are running
# V storage servers.  Then number to the right of the name
# is a V system pid (printed in hex).
# 

"END"
#! /bin/csh -f
set noglob
host $argv | awk '{ success = 0;					\
		    for( i = 1; $i \!~ /:/ && i <= NF; i++ );		\
		    if ( split( $i, nameaddr, ":" ) == 2 )		\
		      {							\
		        if ( split( nameaddr[2], addr, "." ) == 4 )	\
			  {						\
			    success = 1;				\
			    logicalhost = sprintf( "%x000000", addr[4] )\
			    for( j = 1; j < i; j++ )			\
			        printf( "%s\t%s\n", $j, logicalhost );	\
			    printf( "%s\t%s\n", nameaddr[1], logicalhost ); \
			  }						\
		      }							\
	            if ( \!success )					\
		      {							\
		        print "#ERROR - unable to parse next line"	\
		        print "#"$0					\
		      }}'
		       
	          
			    

    
