/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * 3 Megabit Ethernet access routines
 *
 */

#include <errno.h>
#include <types.h>
#include <enet.h>
#include <sgtty.h>
#include <Venviron.h>
#include <Vio.h>
#include <Vioprotocol.h>
#include <Vethernet.h>
#include <Vikc.h>
#include <net.h>
#include <kernel.h>
#include <debug.h>

extern int errno;
extern unsigned char LocalHost;
struct eniocb EnetControlBlk;
extern ProcessId KernelProcessPid;

struct	enfilter PacketFilter =   /* Receive only kernel packets */
  {
    127, /* enf_Priority  */
    15,   /* enf_FilterLen */
    ENF_PUSHWORD+1,ENF_PUSHLIT|ENF_EQ,KERNEL_PACKET, /* Kernel packet */
    ENF_PUSHWORD+7,ENF_PUSHLIT|ENF_EQ, MAIN_SERVER_PID,
    ENF_PUSHWORD+7,ENF_PUSHLIT|ENF_EQ, LOCAL_KERNEL_PROCESS_PID,
    ENF_OR,					     /* accept either pid */
    ENF_PUSHWORD+7,ENF_PUSHLIT|ENF_EQ, 0,	/* Broadcast packet */
    ENF_OR, /* Broadcast or MyPid */
    ENF_AND /* Kernel packet and broadcast or MyPid */
  };


NetOpen( mypid )
  ProcessId mypid;
 /*
  * Open an ethernet connection returning fileid on
  * connection and set up LocalHost;
  */
 {
    register int i, fid;
    struct eniocb *buffer = &EnetControlBlk;
    u_int maxwaiting;
    char fn[16];
    register int failed = 0;

    /* try all ethernet minors from /dev/enet1 on up.
     * do not use /dev/enet0; this is reserved for programs written
     * for the old CMU driver, such as eftp.
     *
     * Algorithm: assumption is that minors start at /dev/enet1
     * and run up as decimal numbers without gaps.  We search
     * until we get an error that is not EBUSY (i.e., probably
     * either ENXIO or ENOENT), or until we sucessfully open one.
     */
    for( i=1; !failed ; i++)
      {
	sprintf (fn, "/dev/enet%d", i);
	if( (fid = open(fn, 2)) >= 0 ) 	
	  {
	    ioctl( fid, FIOCLEX, NULL );    /* Close the file on a UNIX exec */
	    break;
	  }
	/* if we get past the break, we got an error */
	if (errno != EBUSY) failed++;
      }
    if( failed ) return( -1 );

    if( NDebug ) printf( "Opened %s\n", fn );

    /* Get the parameters for this file */
    ioctl( fid, EIOCGETP, buffer );
    LocalHost = buffer->en_addr;

/*    buffer->en_rtout = 1;  /* Set lowest possible read timeout interval */
    ioctl( fid, EIOCSETP, buffer );

    /* Ask for maximum incoming packet buffering */
    maxwaiting = buffer->en_maxwaiting;
    ioctl( fid, EIOCSETW, &maxwaiting );

    /* Flush packets in the input queue */
    ioctl( fid, EIOCFLUSH, 0 );

    /* Set the kernel packet filter */
    PacketFilter.enf_Filter[5] = mypid & 0xFFFF; /* Set Pid field */

    /* only the main server should answer to kernel process requests */
    if ( mypid != MAIN_SERVER_PID )
        PacketFilter.enf_Filter[8] = mypid & 0xFFFF;	/* kernel pid field */

    if( NDebug ) printf( "Filter set for %2x\n", PacketFilter.enf_Filter[5] );

    ioctl( fid, EIOCSETF, &PacketFilter ); /* default is to ignore all */

    return( fid );
  }

NetRead( net, packetlength, apacket,srcpid,destpid,forwarder,
	    length, localaddr, remoteaddr, seqno, msg)
int	net;			/* File id of ethernet */
int	packetlength;		/* Actual packet length */
struct	KernelPacket *apacket;	/* Packet to read */
int	*srcpid,*destpid,*forwarder,
	*length,*localaddr,*remoteaddr;
short	*seqno, *msg;

  /* Receive a packet from the ethernet
   * specified by net and place it in packet.
   */
  {
    extern ProcessId MyPid;
    register kPacketWithSegment *packet= &(apacket->kernelpacket);

    packetlength = read( net, apacket, packetlength );

    if( packetlength < sizeof(struct SmallKernelPacket) ) 
      {
        return( -1 );
      }
    MoveLong( packet->srcPid, *srcpid );
    MoveLong( packet->dstPid, *destpid );
    MoveLong( packet->forwarder, *forwarder );
    MoveLong( packet->length, *length );
    MoveLong( packet->localaddress, *localaddr );
    MoveLong( packet->remoteaddress, *remoteaddr );
    *seqno = packet->sequenceNo;

    /* Discard packet if not a broadcast packet and not for this process */
    if( apacket->netheader.dsthost && *destpid != MyPid 
        && *destpid != KernelProcessPid )
      {
	if( NDebug )
	    printf( "%x: Packet for %x discarded\n", MyPid,*destpid );
	return( -1 );
      }

      {
	register char i = 17;
	register short *msgPtr = (short *)packet->msg;

	 /* copy message */
	while( --i ) *msg++ = *msgPtr++;
      }
    return( packet->packetType );
  } /* NetRead */



NetWrite( packettype, net, packetlength, packet, srcpid, destpid, forwarder,
	    length, localaddr, remoteaddr, seqno, msg)
    short packettype;
    int	net;				/* file id to write to */
    int packetlength;			/* Actual length of packet */
    register struct	KernelPacket *packet;	/* Packet to write */
    int	srcpid,destpid,			/* relevent pids*/
    length,			/* length of encapsulated  part of packet */
    forwarder,
    localaddr,
    remoteaddr;
    short seqno;
    register short *msg;		/* message if exists */
   /* Send a Vkernel packet over the ethernet specified by net
    * set up things like srchost, packettype and srcpid.
    */
  {
    extern unsigned char LocalHost;
    int trans; 
    register kPacketWithSegment *kpacket = &(packet->kernelpacket);

    packet->netheader.srchost = LocalHost;
    packet->netheader.dsthost = *((char *)&destpid + 3); /* extract dest host for pid */
    packet->netheader.packettype = KERNEL_PACKET;
    kpacket->packetType = packettype;

    MoveLong( srcpid, kpacket->srcPid );
    MoveLong( destpid, kpacket->dstPid );
    MoveLong( forwarder, kpacket->forwarder );
    MoveLong( length, kpacket->length );
    MoveLong( localaddr, kpacket->localaddress );
    MoveLong( remoteaddr, kpacket->remoteaddress );
    kpacket->sequenceNo = seqno;
    if( msg != NULL )
      {
	/* copy message */
	register short i = 17;
	register short *msgPtr = (short *)(kpacket->msg);

	while( --i ) *msgPtr++ = *msg++;
      }

    for( trans = 0; trans < 32; ++trans )
	if( write(net, packet, packetlength) != -1 ) return( OK );

    printf( "Network write failed: length = %d\n", packetlength );
    return( DEVICE_ERROR );
    /* abort(); /* Ethernet failure */
  } /* NetWrite */

NetSignal( fid, signum )
   int	fid;		/* file id of an ethernet device */
   int	signum;		/* signal number to set */
  /* Enable or disable a signal on reception of a packet.
   * signum specifies the signal to be invoked if non-zero.
   * Zero signum disable signals.
   */
  {
    ioctl(fid, EIOCENBS, &signum);
  } /* NetSignal */

unsigned char GetLogicalHost()

  /* Return the logical host number for this machine.
   */
  {
    return( LocalHost );
  }

int NetReceiveQLength( net )
   int net;
  /* Return the number of packets waiting in the receive queue */
  {
    int length;

    ioctl( net, FIONREAD, &length );
    return( length );
  }
