/*
 * The V UNIX server: a V kernel and V server simulator for VAX/UNIX
 * that provides a subset of UNIX system services to SUN workstations
 * running the V distributed kernel.
 * Copyright (c) 1982 David R. Cheriton, all rights reserved.
 *
 * Allocates and deallocates packets for kernel
 *
 */

#define MaxSendRequests 25
#include <Vethernet.h>
#include <Vikc.h>
#include <net.h>
#include <kernel.h>

static struct SendRecord	SendStore[MaxSendRequests];
struct SendRecord *SendRoot = SendStore;

InitBufMgr()

 /* Set up storage for packets and send requests 
  *
  */
  {
    register int i;

    SendRoot = SendStore;

    for( i=0; i < (MaxSendRequests-1); i++ )
      SendStore[i].next = &(SendStore[i+1]);
    SendStore[--i].next = NULL;
  }


SendFree( record )
    struct SendRecord *record;
 /* Add packet to the free pool
  *
  */
  {
    record->next = SendRoot;
    SendRoot = record;
  }

struct SendRecord *SendAlloc()

  /* Allocate a packet from Send pool
   *
   */
  {
    register struct SendRecord *record;

    if( SendRoot == NULL ) return( 0 );

    record = SendRoot;
    SendRoot = SendRoot->next;

    return( record );

  }
