/*
 * puntserver.c
 *
 * V-System Punt Server
 * Copyright 1983 (c) All Rights Reserved.
 * David Cheriton
 *
 * The punt server punts all requests
 */

#include "Vpunt.h"

ProcessId InitPuntServer();
static PuntServer();
static Punt();

static ProcessId PuntServerPid;

ProcessId InitPuntServer()
  {
    /*
     * Create and start the punt server.
     */
    ProcessId pid;

    if (ValidPid(pid = GetPid(PUNT_SERVER, LOCAL_PID))) return (pid);
    pid = Create(PUNT_SERVER_PRIORITY, PuntServer, PUNT_SERVER_STACK);
    PuntServerPid = pid;
    if (pid != 0)
      {
	SetPid(PUNT_SERVER, pid, LOCAL_PID);
	Ready(pid, 0);
      }
    return (pid);
  }


static PuntServer()
  {
    /*
     * Base function of the punt server.
     */
    Message msg;
    register PuntRequest *request = (PuntRequest *) msg;
    register PuntReply *reply = (PuntReply *) msg;
    register ProcessId pid;
    register SystemCode r;

    while (1)
      {
	pid = Receive(request);
	
	switch (request->requestcode)
	  {
	     default:
		r = Punt(request, pid);
		break;
	  }

	if (r != NO_REPLY)
	  {
	    reply->replycode = r;
	    Reply(reply, pid);
	  }
      }
  }

static Initialize()
  /*
   * Perform server initialization as needed.
   */
  {
    return;
  }



static Punt(request, pid)
    PuntRequest *request;
    ProcessId pid;
  {
  /*
   * Carry out a punt request
   */
    SystemCode r;
    register PuntReply *reply = (PuntReply *) request;

    return (OK);
  }
