/*
 * V-System Pipe Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

/*
 * Pipe server manifests and structs
 */

#include <Vioprotocol.h>
#include <Vpipe.h>

#define PIPE_MASK          7     /* used in mapping from id to instance. */
#define RECLAIM           0x8999 /* a (hopefully) unique request code for reclamation */
#define REMINDER_STACK     400   /* stack size of reminder process */
#define PIPE_SERVER_STACK 2500	/* stack size for main process */
#define REMIND_TIME        1    /*  number of seconds between reclamations */

struct _Buffer
  {
    struct _Buffer	*next; /* Next buffer in the queue. */
    unsigned 		count; /* Bytes in the buffer */
    unsigned char	data[PIPE_BLOCK_SIZE]; /* Pipe data. */
  };

typedef struct _Buffer Buffer;

/* Structure describing each end of the pipe. A pipe consists of two
 * such records, with the write end instance id even and the read end id
 * one greater.
 */

struct _PipeDesc
  {
    struct _PipeDesc	*link;
    InstanceId		pipeid;
    ProcessId		readowner;
    ProcessId		writeowner;
    unsigned		lastblock;	/* Number of last block written. */
    unsigned 		lastbytes;	/* Number of bytes in last block. */
    unsigned		nextblock;	/* Next block to read or last block. */
    ProcessId		writer;		/* Waiting reader or writer (one only) */
    ProcessId		reader;		/* Waiting reader or writer (one only) */
    Buffer		*nextbuffer;	/* Next data buffer to read  */
    Buffer		*lastbuffer;
    Buffer		*lastbufferread;
    Buffer		*freebuffers;	/* List of free buffers, if any */
  };

typedef struct _PipeDesc PipeDesc;

/* Global variables */

ProcessId    Me;                     /* Process id of the pipe server */
PipeDesc    *Pipe_table[PIPE_MASK+1];
unsigned    Pipe_generator;
unsigned    Pipes;
ProcessId   Reminder_process;       /* id of reminder process */

PipeDesc *Alloc_pipe(), *Get_pipe();
Buffer *CurrentBuffer;
#define Copy blt
