/*
 * localname.h
 *
 * V-System Local Name Server
 * Copyright 1983 (c) All Rights Reserved.
 * David Cheriton, Tim Mann
 */

#define	NAME_SERVER_PRIORITY 3
#define	NAME_SERVER_STACK 2000
#define MAX_PATH_LENGTH 1024
#define MAX_NAME_LENGTH 16
#define CONTEXT_DIRECTORY_SIZE 32
#define DEVICE_DIRECTORY_SIZE 6
#define CONTEXT_DIRECTORY 0
#define DEVICE_DIRECTORY 0x1234
#define CONTEXT_DIRECTORY_INSTANCE 0x5555
#define DEVICE_DIRECTORY_INSTANCE 0x6666

typedef union
  {
    LocalNameDescriptor	c;	/* local name for a context */
    DeviceDescriptor	d;	/* name for a local device */
  } DirectoryEntry;

/* For entrytype field */
#define LOCAL_MASK	 0xFF	/* fields that can only be set locally */
#define IMMUTABLE	 0x10
#define SET_UNSPECIFIED0 0x20

#define null(string) (*(string) == '\0')
