/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer,  8/83
 *	First created.
 */


/*
 * Include file for PUP protocols.
 */




/********************
 *
 * General Definitions
 *
 ********************/


typedef struct PupPortType	/* Pup port definition */
  {
    Bit8 net;
    Bit8 host;
    Bit32 socket;
  } PupPort;

typedef struct PackedPupPortType
				/* Packed Pup port defn. (The regular defn.
				   can't be used due to word alignment
				   problems.) */
  {
    Bit8 net;
    Bit8 host;
    Bit16 fSocket;		/* "Front" socket word. */
    Bit16 bSocket;		/* "Back" socket word. */
  } PackedPupPort;




/********************
 *
 * PUP Definitions
 *
 ********************/


/*
 * Constant definitions
 */

#define MaxPupPacketSize 554
				/* Maximum allowed size of PUP packets.
				   NOTE: MAXPBUFSIZE must be at least
				   MaxPupPacketSize + sizeof(NetAddress)
				   large. */
#define PupPacketOverhead 22	/* Pup packet overhead. */
#define MaxPupDataSize 532	/* Maximum size of data in a PUP packet. */

#define PupStackSize 2000	/* 4000 works */
				/* Size of stack for Pup connection processes.
				   */


/*
 * Type definitions
 */

typedef PupPort PupAddr;	/* PUP address type. */

typedef struct PupTcbType	/* PUP instance transmission control block. */
  {
    int netId;			/* Index of the corresponding network instance
				   descriptor record. */
    Boolean instState;		/* State of connection wrt to open/closed. */
    Boolean receiveBlocked;	/* True if connection process is receive
				   blocked (and hence can't dequeue
				   incoming network packets). */
    RingQueue readerQueue;	/* Packet queue used to queue incoming
				   packets from the network. */
    RingBufRec ringBufs[MAX_RING_BUFS];
				/* Ring buffer pool used in conjunction with
				   the readerQueue to provide synchronization
				   between competing processes. */
    Bit32 socket;		/* Socket for which the connection is 
				   registered. */
    Queue readyQ;		/* Queue of packets waiting to be received. */
    Boolean waitFlag;		/* Flag to signal if a read is 
				   outstanding. */
    ProcessId rcvId;		/* Process id of reader. */
    char *bufferPtr;		/* Address of user's buffer. */
  } PupTcbRec, *PupTcbPtr;

typedef struct pupPkt		/* PUP packet structure.
				   See Pup specs. for defns.
				   of the various fields. */
  {
    Bit16 pupLength;
    Bit8 pupTransport;
    Bit8 pupType;
    Bit32 pupID;
    PackedPupPort dstPort;
    PackedPupPort srcPort;
    Bit8 data[MaxPupDataSize];
    Bit16 checksum;
  } *PupPktPtr;
