/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer,  5/83
 *	First created.
 */


/*
 * Definition file for multi-protocol tables.
 */


#include "net.h"


/* Connection protocols */

extern SystemCode CreateIpConnection();
extern int NextIpTimeout();
extern SystemCode CreateTcpConnection();
extern int NextTcpTimeout();
extern SystemCode CreatePupConnection();
extern int NextPupTimeout();

/* Network level protocols */

extern int RcvAllIp();
extern int RcvAllPup();


struct FuncBlock FuncTable[NumProtocols] =
				/* Function table definition */
  {
    {
      CreateIpConnection,
      NextIpTimeout
    },
    {
      CreateTcpConnection,
      NextTcpTimeout
    },
    {
      CreatePupConnection,
      NextPupTimeout
    }
  };

struct PnetBlock PnetTable[NumPnetProtocols] =
				/* Physical net protocols table. */
  {
    {
      IpEtherType,
      0,
      RcvAllIp
    },
    {
      PupEtherType,
      0,
      RcvAllPup
    }
  };


int NetLevelProtocol[NumProtocols] =
  {
    0,	 			/* IP */
    0,	 			/* TCP */
    1				/* PUP */
  };




/*
 * ActivateNetProtocol:
 * Sets the designated network level protocol as active in PnetTable.
 */

ActivateNetProtocol(prot)
    int prot;
  {
    PnetTable[prot].active = True;
  }




/*
 * DeactivateNetProtocol:
 * Sets the designated network level protocol as inactive in PnetTable.
 */

DeactivateNetProtocol(prot)
    int prot;
  {
    PnetTable[prot].active = False;
  }
