/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Marvin Theimer, 5/83
 * Marvin Theimer, 8/83
 *	Removed various IP specific defns. to the newly created iptcp.h,
 *	prot.h and prot.c files.  This file now contains non-protocol specific
 *	defns. only.
 */


/*
 * Primary internal include file for the internet server.
 */


#include <Vioprotocol.h>
#include "Vnet.h"
#include "pnet.h"
#include "prot.h"


/*
 * General definitions
 */

typedef unsigned char   Bit8;
typedef unsigned short  Bit16;
typedef unsigned long   Bit32;

typedef int Boolean;
#define True 1
#define False 0

#define Null 0
#define Null16 (Bit16) 0
#define Null32 (Bit32) 0



#define	MAXPBUFSIZE	1100	/* Size of a packet buffer.  Should not be
				   larger than 1100 to avoid stack 
				   overflows. */

#define Timer1Interval 500	/* Timing interval for timer1. */

#define MAX_NET_INST 50		/* Maximum number of network connections
				   that can be handled. */
#define MAX_RING_BUFS 30	/* Maximum number of packets that can be
				   queued in a ring buffer.  This number
				   effectively is the maximum number of
				   packets that can be queued for any given
				   network connection. */

/*
 * Network connection instance states.
 */
#define READ_INST 1		/* Read instance active bit */
#define WRITE_INST 2		/* Write instance active bit */

#define MaxInt ((int) 0x7fffffff)
				/* Largest nonnegative integer on a 32 bit
				   machine. */

/*
 * Network server events.
 */
#define NetPktRcvd 0
#define NetTimeout 1

/*
 * Network timer event types.
 */
#define ConnTimeout 0
#define InvalidConnOwner 1


/*
 * Record formats
 */

typedef struct pbuf		/* Packet buffer */
  {
    struct pbuf	*next;		/* link to next pbuf in a Queue */
    int	length;			/* number of valid data bytes */
    char *dataptr;		/* pointer to first valid data byte */
    unsigned unspecified[2];
    char data [MAXPBUFSIZE];	/* actual data bytes are in here .
				   NOTE: must be word-alligned. */
  } *PktBuf;

typedef struct			/* Queue header */
  {
	PktBuf	head;
	PktBuf	tail;
  } Queue;

typedef struct RingBufType	/* Ring buffer */
  {
    PktBuf pkt;
    struct RingBufType *next;
  } RingBufRec, *RingBuf;

typedef struct			/* Ring queue header */
  {
    RingBuf head;
    RingBuf tail;
  } RingQueue;

struct NetInstDescr		/* Network connection instance
				   descriptor. */
  {
    unsigned char inUse;
    int next;
    ProcessId ownerPid;		/* Process id of instance owner. */
    int prot;
    ProcessId pid;		/* Process id of process associated with this
				   instance. */
    unsigned tcbId;		/* Ptr or index to protocol-specific 
				   transmission control block. */
    int blocksize;
    int filelastbytes;
    int filelastblock;
    int filenextblock;
  };


/*
 * Various global variables
 */

short InternetDebug;		/* Debugging flag. */

int FreeBufferCount, TotalBufferCount;
				/* Number of allocated packet buffers that
				   are resp. on the free list and total in
				   the system. */

struct NetInstDescr NetInstTable[MAX_NET_INST];
				/* Network instance descriptor records. */
int NetInstHead, NetInstFree;

int Time0;			/* Initial seconds time when internet server
				   started up.  This is used to normalize the
				   current time (which is in clicks). */
int CurrentTime;		/* Current time. */
int NextTimeout;		/* Time of next timeout. */
ProcessId TimerPid;		/* Process id of the connection timeout
				   timer process. */


/*
 * Tuning variables - see parms.c for defns.
 */

int BufAllocNum, BufAllocMax, MaxBufAllocNum;


/*
 * General macro definitions
 */

#define Max(a,b) ((a) >= (b)) ? (a) : (b)
#define Min(a,b) ((a) < (b)) ? (a) : (b)

#define RoundUp(x) ((x+1) & ~1)
#define RoundDown(x) (x & ~1)

#define FreeBuf(pkt) DeallocBuf(pkt)

#define CTime(s, c) ((s<<6) + (s<<5) + (s<<2) + c)
				/* Converts seconds and clicks to clicks. */

/*
 * Queueing macros.
 */

#define Empty(Q) (Q.head == NULL)

/*
 * Doubly-linked list manipulation routines.
 */

#define AddList(ptr, rec)			\
	/* Add rec after ptr. */		\
	{					\
	rec->prev = ptr;			\
	rec->next = ptr->next;			\
	(ptr->next)->prev = rec;		\
	ptr->next = rec;			\
	}

#define DeleteList(ptr)				\
	{					\
	(ptr->prev)->next = ptr->next;		\
	(ptr->next)->prev = ptr->prev;		\
	}

#define InitList(ptr)				\
	/* Make into a one-element list. */	\
	{					\
	ptr->prev = ptr;			\
	ptr->next = ptr;			\
	}
