/*
 * openpad.c - routines to open files pointing to pads
 *
 * Bill Nowicki February 1983
 */

# include <Vioprotocol.h>
# include <Vgts.h>

extern File *_Open();

File *OpenPad(name, lines, columns, error)
  char *name;
  short lines, columns, *error;
  {
    CreateInstanceRequest req;
    
    if (name==NULL) name = "Unknown";
    req.requestcode = CREATE_INSTANCE;
    req.filenamelen = strlen(name);
    req.filenameindex = 0;
    req.filename = name;
    req.type = 0;
    req.unspecified[0] = lines;
    req.unspecified[1] = columns;
    return( _Open(&req, FCREATE|FRELEASE_ON_CLOSE, 
    	GetPid(VGT_SERVER, LOCAL_PID), error) );

  }


SelectPad(file)
 File *file;
  {
  	/*
	 * Selects the given pad for input
	 */
    IoRequest msg;
    msg.requestcode = (SystemCode)SwitchInput;
    msg.fileid = file->fileid;
    Send( &msg, file->fileserver );
  }

ModifyPad(file,mode)
    File *file;
  {
  	/*
	 * Set the mode for the indicated file
	 */
    struct ModifyMsg msg;
    
    msg.requestcode = MODIFY_FILE;
    msg.fileid = file->fileid;
    msg.mode = mode;
    Send( &msg, file->fileserver );    
  }

QueryPad(file)
    File *file;
  {
  	/*
	 * Query the mode for the indicated file
	 */
    struct ModifyMsg msg;
    
    msg.requestcode = QUERY_FILE;
    msg.fileid = file->fileid;
    Send( &msg, file->fileserver );    
    return(msg.mode);
  }
