/*
 * termsession.c
 * Terminate a session and invalidate its name
 */

#include "../include/Vnaming.h"
#include "../include/Vioprotocol.h"

SystemCode TerminateSession(sessionname)
    char *sessionname;
  {
    Message msg;
    register long *msgp = (long *) msg;
#define nrequest ((ContextRequest *) msgp)
#define nreply ((ContextReply *) msgp)
#define irequest ((IoRequest *) msgp)
#define ireply ((IoReply *) msgp)
    ProcessId nameserverpid, sessionpid;
    InstanceId sessioniid;

    /* Lookup the session name */
    nrequest->requestcode = GET_CONTEXT_ID;
    nrequest->namecontextid = DEFAULT_CONTEXT;
    nrequest->nameindex = 0;
    nrequest->nameptr = sessionname;
    nrequest->namelength = strlen(sessionname);
    nameserverpid = GetPid(NAME_SERVER, LOCAL_PID);
    Send(nrequest, nameserverpid);
    if (nreply->replycode != OK) return(nreply->replycode);
    if ((nreply->entrytype & SESSION) == 0)
        return(NONEXISTENT_SESSION);  /* not the name of a session */
    sessionpid = nreply->serverpid;
    sessioniid = nreply->instanceid;

    /* Release the session instance */
    irequest->requestcode = RELEASE_INSTANCE;
    irequest->fileid = sessioniid;
    irequest->releasemode = OK;
    Send(irequest, sessionpid);
    if (ireply->replycode != OK) return (ireply->replycode);

    /* Invalidate the session name */
    nrequest->requestcode = DELETE_CONTEXT_NAME;
    nrequest->nameindex = 0;
    nrequest->namecontextid = DEFAULT_CONTEXT;
    nrequest->nameptr = sessionname;
    nrequest->namelength = strlen(sessionname);
    Send(nrequest, nameserverpid);
    return (nreply->replycode);

#undef nrequest
#undef nreply
#undef irequest
#undef ireply
   }
