/*
 * Function-call interface to GET_FILE_NAME message.  Gets the name
 * of the file associated with the instanceid and serverpid.
 *
 * Returns a null terminated string in name.
 * namelength - size of the name buffer
 * serverpid - for the file
 * instanceid - of the file
 */

#include "../include/Vnaming.h"

SystemCode GetFileName(name, namelength, serverpid, contextid, instanceid)
    char *name;
    unsigned *namelength;
    ProcessId *serverpid;
    ContextId *contextid;
    InstanceId instanceid;
  {
    Message msg;
    register ContextRequest *request = (ContextRequest *) msg;
#define reply ((ContextReply *) request)
    ProcessId nameserverpid;

    request->requestcode = GET_FILE_NAME;
    request->nameindex = 0;
    request->serverpid = *serverpid;
    request->contextid = 0;
    request->entrytype = 0;
    request->instanceid = instanceid;
    request->otherinfo = 0;
    request->namecontextid = 0;
    request->nameptr = name;
    request->namelength = *namelength;

    Send(request, *serverpid);

    if( reply->replycode != OK )
      {
	*name = NULL;	/* mark string as zero length */
        return (reply->replycode);
      }

    /* else terminate the string */
    name[ reply->namelength ] = NULL;
    *serverpid = reply->serverpid;
    *contextid = reply->contextid;
    *namelength = reply->namelength;
    return (reply->replycode);

#undef reply

  } /* GetFileName */
