/*
 * delctxname.c
 * Function-call interface to DELETE_CONTEXT_NAME message.  Removes the
 *   definition of a context name, but does not delete the context.
 *
 * Tim Mann 8-4-83
 */

#include "../include/Vnaming.h"

SystemCode DeleteContextName(name)
    char *name;
  {
    Message msg;
    register ContextRequest *request = (ContextRequest *) msg;
    register ContextReply *reply = (ContextReply *) msg;
    ProcessId nameserverpid;

    /* Send the request to (or through) the local name server */
    nameserverpid = GetPid(NAME_SERVER, LOCAL_PID);

    request->requestcode = DELETE_CONTEXT_NAME;
    request->nameindex = 0;
    request->namecontextid = DEFAULT_CONTEXT; /* Used to interpret name */
    request->nameptr = name;
    request->namelength = strlen(name);

    Send(request, nameserverpid);

    return (reply->replycode);

  }
