/*
 * addctxname.c
 * Function-call interface to ADD_CONTEXT_NAME message.  Defines a name
 *   for a context specified as (serverpid, contextid).
 *
 * Tim Mann 8-4-83
 */

#include "../include/Vnaming.h"

SystemCode AddContextName(name, serverpid, contextid)
    char *name;
    ProcessId serverpid;
    ContextId contextid;
  {
    Message msg;
    register ContextRequest *request = (ContextRequest *) msg;
    register ContextReply *reply = (ContextReply *) msg;
    ProcessId nameserverpid;

    /* Send the request to (or through) the local name server */
    nameserverpid = GetPid(NAME_SERVER, LOCAL_PID);

    request->requestcode = ADD_CONTEXT_NAME;
    request->nameindex = 0;
    request->serverpid = serverpid;
    request->contextid = contextid;
    request->entrytype = 0;
    request->instanceid = 0;
    request->otherinfo = 0;
    request->namecontextid = DEFAULT_CONTEXT; /* Used to interpret name */
    request->nameptr = name;
    request->namelength = strlen(name);

    Send(request, nameserverpid);

    return (reply->replycode);

  }
