            .ent        .Zero
            .rel        _CODE_RBR
            .formal     2
            .arg        unsigned[]
            .arg        unsigned
            .returns    unsigned[]

.Zero:      movea       A0, @A6         \ A0 <-- address of words to zero
            move        D0, 2[A6]       \ D0 <-- last word offset (count-1)

            addq        D0, 1           \ Make D0 count of words to zero.
            lsr         D0, 1           \ Divide count to get long words.
            bcc         begin           \ If count of words to zero is even
                                        \ then start zeroing long words,
            clr         @A0++           \ otherwise zero first word
            tst         D0              \ then loop, but

begin:      beq         end             \ make sure count is greater than 1.

loop:       clrl        @A0++           \ Clear long words until
            subq        D0, 1           \ count goes to 0.
            bne         loop

end:        move        D7, @A6         \ Return starting address.
            rts

            .end
