/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * Seek
 */

#include "Vioprotocol.h"


Seek( fad, offset, origin ) 
  register File *fad; 
  int offset; 
  unsigned origin;
  /*
   * Seek to the byte location in the file specified by offest and origin.
   * The file is left in reading mode if open for reading otherwise
   * it is left in invalid mode (byte position stored in fad->temp).
   * Return 1 if the seek succeeds else false.
   */
  {
    register unsigned newblock;
    register int newindex, length;  /* length must be signed so that dividing
					by length is done as signed division */
    unsigned successful;

    if ( fad->type & FBLOCK_MODE ) return( 0 ); /* Should be an abort */

    /* Calculate the new position in the file in terms of the
     * block number and position within that block.
     */

    if ( fad->readindex != MAXUNSIGNED )
      {
	fad->tempindex = fad->readindex;
	fad->tempblock = fad->block;
	fad->readindex = MAXUNSIGNED;
      }
    else
    if ( fad->writeindex != MAXUNSIGNED )
      {
	if ( fad->fileserver ) fad->state |= MODIFIED_BUFFER;
	fad->tempindex = fad->writeindex;
	fad->tempblock = fad->block;
	fad->bytes = (fad->writeindex < fad->bytes) ? fad->bytes : fad->writeindex;
	fad->writeindex = MAXUNSIGNED;
      }
    newindex = fad->tempindex;
    newblock = fad->tempblock;
    length = fad->blocksize;
    fad->state &= ~EOF_BYTE;

    switch( origin )
      {
	case ABS_BLK:
	  {
	    newblock = offset;
	    newindex = 0;
	    break;
	  }
	case REL_BYTE:
	  {
	    newindex += offset;
	    break;
	  }
	case ABS_BYTE:
	  {
	    newblock = 0;
	    newindex = offset;
	    break;
	  }
	case FILE_END:
	  {
	     newblock = fad->lastblock;
	     newindex = fad->lastbytes + offset;
	     break;
	  }
	case FLUSH: break;

	default: return( 0 );
      }
    /* Adjust newindex such that 0 <= newindex < length. */
    newblock += newindex/length;
    newindex %= length;
    if ( newindex < 0 )
      {
	--newblock;
	newindex += length;
      }
    /* Update the contents of the file buffer according to the new
     * position in the file. If moving to a new block or if flushing
     * then update the buffer.
     */
    successful = 1;
    if ( (fad->bytes == 0) || (newblock != fad->tempblock) || (origin == FLUSH) )
      {
	if ( fad->state & MODIFIED_BUFFER )
	  {
	     fad->bytes = Write( fad, fad->buffer, fad->bytes );
	     fad->state &= ~MODIFIED_BUFFER;
	     if ( fad->lastexception != OK ) return( 0 );
	  }
	if ( origin == FLUSH ) return( 1 );

	fad->bytes = 0;
	fad->lastexception = 0;

	if ( fad->type & FIXED_LENGTH && (newblock > fad->lastblock ||
	((newblock==fad->lastblock) && newindex > fad->lastbytes)) )
	  {
	    newblock = fad->lastblock;
	    newindex = fad->lastbytes;
	    successful = 0;
	  }
	fad->block = newblock;

	/* Check if beyond last block to avoid unnecessary reads */
	if ( fad->type&READABLE )
	  {
	    if ( (fad->type & (FIXED_LENGTH|WRITEABLE)) &&
	    (newblock > fad->lastblock || (newblock == fad->lastblock &&
					fad->lastbytes == 0) ) )
		fad->lastexception = END_OF_FILE;
	    else
		fad->bytes = Read( fad, fad->buffer, length );
	  }
      }
    /* All is OK so make the new position in the file current and
     * leave in reading mode if possible.
     */
    fad->tempindex = newindex;
    fad->tempblock = newblock;

    if ( fad->type & READABLE ) fad->readindex = newindex;

    return( successful );
  }

