#include "Vioprotocol.h"

SystemCode Resynch( fad )
	File *fad;
/*
 * Resynchronize next block to read and next block to write
 *  in fad with file instance.  Any buffered bytes are lost.
 *  (Streams only.)
 */
  {
    Message msg;
    register QueryInstanceRequest *req = (QueryInstanceRequest *) msg;
    register QueryInstanceReply *reply = (QueryInstanceReply *) msg;

    if ( !(fad->type & STREAM) ) return;

    req->requestcode = QUERY_INSTANCE;
    req->fileid = fad->fileid;
    req->filemode = FAPPEND;  /* does this matter? */

    Send( req, fad->fileserver );
    if( reply->replycode != OK ) return( reply->replycode );

    fad->lastblock = reply->filelastblock;
    fad->lastbytes = reply->filelastbytes;
    fad->readindex = fad->writeindex = MAXUNSIGNED;
    fad->tempindex = fad->bytes = 0;
    fad->state &= ~EOF_BYTE;

    if (fad->type & READABLE)
	fad->block = fad->tempblock = reply->filenextblock;
    else Seek( fad, 0, FILE_END );
/*	fad->block = fad->tempblock = reply->filelastblock+1; */

    return (OK);
  }
