/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 *  Read
 */

#include "Vioprotocol.h"


Read( fad, buffer, bytes ) File *fad; char *buffer; int bytes;

   /* Read the specified number of bytes into the buffer from the
    * file instance specified by fad. The number of bytes read is
    * returned.
    */
  {
    Message	msg;
    register IoRequest	*request = (IoRequest *) msg;
    register IoReply	*reply = (IoReply *) msg;
    register unsigned r, count;
    register char *buf;

    for(;;)
      {
	request->requestcode = READ_INSTANCE;
	request->fileid = fad->fileid;
	request->bufferptr = buffer;
	request->bytecount = bytes;
        request->blocknumber = fad->block;

	Send( request, fad->fileserver );

	if ( (r = reply->replycode) != RETRY ) break;
      }	

    fad->lastexception = r;
    if( r == NONEXISTENT_PROCESS || r == KERNEL_TIMEOUT )
	return( 0 );
    else
	count = reply->bytecount;

    if ( count <= IO_MSG_BUFFER )
      {
	buf = (char *) request->shortbuffer;
	for( r = 0; r < count; ++r ) *buffer++ = *buf++;
      }
    return( count );
  }
