/*
 * freopen.c
 */
#include "Vioprotocol.h"

extern File *Open();

static Copy(dst, src, length)
  register char *dst, *src;
  int length;
  {
    register char *end = src + length;

    while (src < end) *dst++ = *src++;
  }


File *freopen( pathname, mode, fad )
   char *pathname; register char *mode; File *fad;

  /*  Freopen opens the file specified by pathname, positioning it for
   *   read, write, or append operations, depending on the contents
   *   of mode.
   *   Mode is specified as in Unix ("r", "w", "a", "r+", "w+", "a+"),
   *   with the exception that the V library provides no "write only"
   *   mode.  Thus "w" and "w+" are equivalent here.
   *   It then closes the file associated with fad and uses this
   *   descriptor for the new open file.
   */

{
    extern File *TeamFileList;
    Message Msg;
    register IoRequest *request = (IoRequest *)Msg;
    register File *p, *c;
   SystemCode error;
   register int readandwrite;
   File        *FileId;

   Flush( fad ); /* Flush file to be reopened. */

   readandwrite =  mode[ 1 ] == '+';

  /*  If mode is "w", create a new instance of the file. FCREATE allows
   *  both reading from and writing to the file.
   */

   if( mode[ 0 ] == 'w' )

      FileId = Open( pathname, FCREATE, &error );

  /*  If mode is "a", position the file at its end, for both reading and
   *  writing, or for writing only.
   */

   else if( mode[ 0 ] == 'a' )
	{
	  if( readandwrite )
	     {
		FileId = Open( pathname, FMODIFY, &error );
		Seek( FileId, 0, FILE_END );
	     }
	  else
		FileId = Open( pathname, FAPPEND, &error );
	}

   /*  If the mode is "r", open the file for both reading and writing,
    *  or for reading only.
    */

   else if( mode[ 0 ] == 'r' )
	{	
	   if( readandwrite )
		FileId = Open( pathname, FMODIFY, &error );
	   else
		FileId = Open( pathname, FREAD, &error );
	}
   else
	{
           FileId = Open( pathname, FREAD, &error );
	}

    /* Now close fad. */
    if ( fad->type & FRELEASE_ON_CLOSE )
      {
	request->requestcode = RELEASE_INSTANCE;
	request->fileid = fad->fileid;
	request->releasemode = OK;

	Send( request, fad->fileserver );
      }
    if ( fad->buffer && fad->fileserver ) free( fad->buffer );

    /* Copy the new file descriptor into fad, keeping link field intact. */
    p = fad->link;
    Copy( fad, FileId, sizeof(File) );
    fad->link = p;

    /* Free the new file descriptor */
    if ( FileId == TeamFileList ) TeamFileList = FileId->link;
    else
      {
	p = TeamFileList;
	while( ((c = p->link) != NULL ) && (c != FileId) ) p = c;
        if ( c == NULL ) return;

	p->link = c->link;
      }
    free( FileId );

    return( fad );
  }
