/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * I/O routines that implement the I/O protocol.
 * CreateInstance
 */

#include "Vioprotocol.h"
#include "Vnaming.h"


SystemCode CreateInstance( name, mode, req ) char *name; int mode;
				CreateInstanceRequest *req;

  /* Create an instance of the file specified by name in the
   * usage mode and return the reply from the request in req.
   * The reply code is returned by the function.
   * This is only used for creating instances when additional
   * server-dependent information is passed in the request message.
   */
  {
    unsigned id;
    register CreateInstanceReply *reply = (CreateInstanceReply *) req;
    ProcessId pid;

    req->requestcode = CREATE_INSTANCE;
    req->filename = name;
    req->filenamelen = strlen( name );
    req->filenameindex = 0; /* Use the entire name */
    req->filemode = mode;

    /* Send to local name server if context specified,
     *  else to current file server */
    Send(req, DirectToCurrentContext(req));

    return( reply->replycode );
  }
