/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * Change directory operation.
 * Rewritten 8-4-83 for new naming protocol (TPM)
 */
#include "../include/Vioprotocol.h"
#include "../include/Vnaming.h"

SystemCode ChangeDirectory(name)
    char *name;
  {
    /* Change the working directory for this process
     *   to the specified name */
    Message msg;
    register ContextRequest *req = (ContextRequest*) msg;
    register ContextReply *reply = (ContextReply *) msg;
    ProcessId pid;

    req->requestcode = GET_CONTEXT_ID;
    req->nameindex = 0;
    req->nameptr = name;
    req->namelength = strlen( name );

    /* Interpret the name to change to in the current context */
    Send(req, DirectToCurrentContext(req));

    if (reply->replycode != OK) return (reply->replycode);

    /* Reset current working context */
    PerProcess->nameserver = reply->serverpid;
    PerProcess->contextid = reply->contextid;

    return (OK);
  }

chdir( name ) char * name;
  {
    return( ChangeDirectory(name) ? -1 : 0 );
  }
