/*
 * V Kernel I/O - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex I/O system)
 *
 * _Open
 */

#include "Vioprotocol.h"

File *_Open( req, mode, server, error ) register CreateInstanceRequest *req;
					short unsigned mode;
					ProcessId server;
					SystemCode *error;

  /*
   * Common routine for both Open and OpenFile.
   */
  {
    extern File *TeamFileList;
    register File *fad;
    register CreateInstanceReply *reply = (CreateInstanceReply *) req;
    IoRequest *ioreq = (IoRequest *) req;
    char *pathname;
    unsigned localtype;

    if ( error ) *error = OK;

    fad = 0;
    pathname = (req->requestcode == CREATE_INSTANCE) ?
		req->filename : "OpenFile";

    localtype = mode & (FBLOCK_MODE|FRELEASE_ON_CLOSE);
    mode &= ~localtype; /* Strip off local type bits. */

    if ( (fad = (File *) calloc(1,sizeof(File))) == NULL )
      {
	reply->replycode = NO_MEMORY;
	goto exception;
      }
    req->filemode = mode;

    Send( req, server );

    if ( reply->replycode != OK ) goto exception;

    fad->fileserver = reply->fileserver;
    fad->fileid = reply->fileid;
    fad->blocksize = reply->blocksize;
    fad->lastblock = reply->filelastblock;
    fad->lastbytes = reply->filelastbytes;
    fad->type = reply->filetype | localtype;

    if ( fad->type & STREAM )
      {
	fad->type &= ((mode&0x0F) == FREAD) ? ~WRITEABLE : ~READABLE;
	fad->tempblock = reply->filenextblock;
      }
    fad->readindex = MAXUNSIGNED;
    fad->writeindex = MAXUNSIGNED;

    if ( !(localtype & FBLOCK_MODE) )
      {
	if ( (fad->buffer = (unsigned char *) calloc(1,fad->blocksize)) == NULL )
	  {
	    if ( localtype & FRELEASE_ON_CLOSE )
	      {
		ioreq->requestcode = RELEASE_INSTANCE;
		ioreq->fileid = fad->fileid;
		Send( ioreq, fad->fileserver );
	      }
	    reply->replycode = NO_MEMORY;
	    goto exception;
	  }
      }
    if( (mode&0x0F) == FAPPEND )
	if ( localtype & FBLOCK_MODE ) fad->block = fad->lastblock;
	else Seek( fad, 0, FILE_END );

    fad->link = TeamFileList;
    TeamFileList = fad;
    return( fad );

exception:
    if ( error == 0 )
	abort();
    else
	*error = reply->replycode;

    if ( fad )
      {
	if ( fad->buffer ) free( fad->buffer );
        free( fad );
      }
    return( NULL );
  }
