/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Vkernel I/O protocol manifests, types and structures.
 */

#ifndef VIOPROTOCOL

#define VIOPROTOCOL

#include "Vio.h"

/* Structures defining the template structure of standard I/O request
 * and reply messages.
 */
typedef struct
  {
    SystemCode		requestcode;
    short unsigned	filenameindex;	/* First byte of filename to use */
    short unsigned	type;		/* The type of file to create */
    short unsigned	filemode;
    unsigned		unspecified[3];	/* Server-dependent */
    ContextId		contextid;	/* Context used to interpret name */
    char		*filename;
    unsigned		filenamelen;
  } CreateInstanceRequest;

typedef struct
  {
    SystemCode		replycode;
    InstanceId		fileid;		/* File instance identifier */
    ProcessId		fileserver;	/* Server process for I/O requests */
    unsigned		blocksize;	/* Maximum block size for I/O */
    unsigned short	filetype;	/* Instance type attributes */
    unsigned short	filelastbytes;  /* Number of bytes in last block */
    unsigned		filelastblock;	/* Laxt block in file */
    unsigned		filenextblock;	/* Next block to read if READABLE STREAM */
  } CreateInstanceReply;

typedef struct
  {
    SystemCode		requestcode;
    InstanceId		fileid;
    unsigned short	blat;		/* padding */
    unsigned short	filemode;	/* aligned with CreateInstanceReq */
    unsigned		unspecified[6];
  } QueryInstanceRequest;
#define QueryInstanceReply	CreateInstanceReply

/* Number of bytes that will fit in an I/O request or reply message */

#define IO_MSG_BUFFER (sizeof(Message) - (sizeof(SystemCode)+sizeof(InstanceId)+sizeof(char *)+sizeof(unsigned)))

typedef struct
  {
    SystemCode		requestcode;
    InstanceId		fileid;
    unsigned		blocknumber;
    char		shortbuffer[IO_MSG_BUFFER-sizeof(char *)];
    char		*bufferptr;
    unsigned		bytecount;
  } IoRequest;

#define instanceowner	blocknumber	/* Used by SetInstanceOwner */
#define releasemode	blocknumber	/* Used by Close */

typedef struct
  {
    SystemCode		replycode;
    InstanceId		fileid;
    unsigned		garbage;	/* Filler to match IoRequest format */
    char		shortbuffer[IO_MSG_BUFFER];
    unsigned		bytecount;
  } IoReply;

typedef struct
  {
    SystemCode		requestcode;
    InstanceId		fileid;
    ProcessId		breakprocess;
    unsigned		unspecified[6];
  } SetBreakRequest;

#endif VIOPROTOCOL
