/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Vkernel I/O manifests, types and structures.
 */

#ifndef VIO

#define VIO

#include "Venviron.h"

typedef	short unsigned	InstanceId;


#define  EOF  (-1)

/* File modes used when creating or querying file instances. */
      /* Basic modes: */
#define FREAD			0x0001
#define FCREATE			0x0002
#define FAPPEND			0x0003
#define FMODIFY			0x0004
#define FBASIC_MASK		0x0007
      /* Additional mode bits: */
#define FDIRECTORY		0x0008
#define FEXECUTE		0x0010
#define FSESSION		0x0020
#define FADDITIONAL_MASK	0x0038

/* Local mode flags.  Must not overlap file modes above or file
 *   instance attribute bits below.
 */
#define FBLOCK_MODE		0x0080
#define FRELEASE_ON_CLOSE	0x0040
#define FLOCAL_MASK		0x00C0

/* File instance attributes. A set of attributes is returned specifying
 * the file instance type in the reply to a create instance or query
 * instance request.
 */
#define READABLE		0x8000
#define WRITEABLE		0x4000
#define APPEND_ONLY		0x2000
#define STREAM			0x1000
#define FIXED_LENGTH		0x0800
#define VARIABLE_BLOCK		0x0400
#define MULTI_BLOCK		0x0200
#define INTERACTIVE		0x0100
#define ATTRIBUTE_MASK		0xFF00
/* Different modes for Seek */

#define ABS_BYTE	0
#define REL_BYTE	1
#define FILE_END	2
#define ABS_BLK		3
#define FLUSH		4
#define FILE_BEGINNING  5
#define FILE_CURRENT_POS 6

/* File Access Descriptor (FAD)
 * There is one FAD per "open" file. This is maintained in the
 * client process's space by the client process.
 */
struct _FAD
  {
    struct _FAD		*link;		/* Next FAD in list */
    InstanceId		fileid;		/* Instance id for the file */
    ProcessId		fileserver;	/* Server process for instance */
    unsigned short	state;		/* Internal state of FAD */
    unsigned short	lastexception;	/* Last exception code set */
    unsigned short	type;		/* File type attributes */
    unsigned short	blocksize;	/* Maximum in bytes to read or write */
    unsigned short	tempindex;	/* Temporary storage for file index */
    unsigned short	readindex;	/* getc byte offset */
    unsigned short	writeindex;	/* putc byte offset */
    unsigned short	bytes;		/* Number of data bytes in buffer */
    unsigned		block;		/* Current block number */
    unsigned		tempblock;
    unsigned            lastblock;
    unsigned short	lastbytes;
    unsigned char	*buffer;
  };
typedef struct _FAD File;

#define FILE File

/* FAD state bit assignments */
#define MODIFIED_BUFFER		0x0010
#define EOF_BYTE		0x0020

/* Standard per-process area */
typedef struct
  {
    File *stdio[3];  		/* For stdin, stdout, stderr */
    ProcessId nameserver;	/* Default file (name) server */
    ContextId contextid;	/* Default context for above */
    unsigned stackSize;		/* Stack size for this process */
  }
PerProcessArea;

extern PerProcessArea *PerProcess;
#define stdin PerProcess->stdio[0]
#define stdout PerProcess->stdio[1]
#define stderr PerProcess->stdio[2]

#define getc(fad)	( ((fad)->readindex >= (fad)->bytes) ? 		    \
			    FillBuffer(fad) :				    \
			    (fad)->buffer[(fad)->readindex++] )

#define putc(byte, fad) ( (fad)->writeindex >= (fad)->blocksize  ?	    \
		            FlushBuffer((fad), (byte)) :		    \
            		    ((fad)->buffer[(fad)->writeindex++] = (byte)) )

#define getchar() getc(stdin)

#define putchar(byte) putc((byte), stdout)

extern File *fopen(), *_Open(), *OpenFile(), *Open(), *OpenStr(), *freopen();

#endif VIO
