/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 *
 * Vkernel Ethernet manifests, structs, etc.
 */

#ifndef VETHERNET
#define VETHERNET

#include "Vio.h"
#include "Vdevicetypes.h"

#define ENET_MAX_PACKET		1500	/* In bytes */
#ifdef ENET3MEG
typedef unsigned char NetAddress;
#else
#ifdef ENET10MEG
typedef struct
  {
    unsigned short	addrhigh,
    			addrmid,
			addrlow;
  } NetAddress;
#endif
#endif


#define ETHERINSTANCE 14

struct _EnetBlock
  {
    NetAddress		DestHost;	/* Id of destination host */
    NetAddress		SrcHost;	/* Id of source host */
    unsigned short	EtherType;	/* EtherType of packet */
    unsigned char	data[ENET_MAX_PACKET];	/* actual data bytes */
  };

typedef struct _EnetBlock EnetBlock;

typedef struct
  {
    SystemCode		requestcode;
    short unsigned	filenameindex;	/* First byte of filename to use */
    short unsigned	type;		/* Type of device to create */
    short unsigned	filemode;
    unsigned		receivermask;	/* Mask controlling packet receive */
    unsigned 		unspecified[2];	/* Server-dependent */
    ContextId		contextid;	/* Context used to interpret name */
    char		*filename;
    unsigned		filenamelen;
  } CreateEnetRequest;


/* Receive Mask Bit Assignments */

#define ENET_SELF		1	/* Receive Packets for this host */
#define	ENET_BROADCAST		2	/* Receive broadcast packets */
#define ENET_PROMISCUOUS	4	/* Receive all packets */

#define ENET_DEFAULT_MASK	(ENET_SELF+ENET_BROADCAST)

/* Ethernet Query Reply Message Format. Request format uses the IoRequest
 * struct with only the request code (QUERY_FILE) and file instance fields
 * significant.
 */

typedef struct
  {
    SystemCode		replycode;
    /* Ethernet specific stuff */
    NetAddress		EthernetHostNumber;
    int			NumValidPackets;
    short		NumCollisions;
    short		NumOverflows;
    short		NumCRCErrors;
    short		NumSyncErrors;
    short		NumTimeOuts;
  } QueryEnetReply;
#endif
