/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * SetUpArguments:
 * Sets up the arguments on the new program's stack
 *
 * Originally written by Bill Nowicki.
 *
 * 7/83 Marvin Theimer
 *	Made into a separate library routine.
 * 9/21/83 TPM
 *	Added free(stack) so we don't munch memory.
 */

#include <Vprocess.h>

extern char *malloc();


SetUpArguments( newpid, args )
    ProcessId newpid;
    char *args[];
  {
    Processor_state teamstate;
    int argc, total;
    char *sp;
    char *stack;
    register int *p;
    register char *string;

	/*
	 * first calculate how much stack space we will need by counting
	 * the number of arguments and their total size. Round up
	 * to get things aligned on even boundaries.
	 * In addition to the string length, we need argc*4 + 16 more bytes:
	 *	4 for a dummy return address,
	 *	4 for argument count
	 *	4 for argument vector pointer
	 *	4 for each argument
	 *	4 for an extra NULL argument pointer
	 */

    ReadProcessState(newpid,&teamstate);
    sp = (char *) teamstate.USER_STACK_POINTER;
    for ( argc=0, p=(int *)args, total=0;
    		*p;argc++,p++) 
		    total += strlen(*p) + 1;

    total += (total&1);
    total += argc*4 + 16;
    sp -= total;
    stack = malloc(total);
    p = (int *)stack;
	/* 
	 * put a dummy return address for TeamRoot on top of the stack
	 * so that it will get an exception if it tries to return.
	 */
    *p++ = 0xbad;

    	/*
	 * Next on the stack goes the argument count, followed by a pointer
	 * to the argument array.
	 */
    *p++ = argc;
    *p++ = (int) sp + 12;
    string = (char *) (p+argc+1);
    while (argc--)
      {
       register char *src = *args++;
       *p++ = (int) ( (string - stack) + sp);
       while (*src) *string++ = *src++;
       *string++ = 0;
      }
    *p++ = 0;

    MoveTo(newpid,sp,stack,total);
    teamstate.USER_STACK_POINTER = (Unspec) sp;
    WriteProcessState(newpid,&teamstate);
    free(stack);
  }
