/*
 * Distributed V Kernel - Copyright (c) 1982 by David Cheriton, Willy Zwaenepoel
 * (Transliterated from Zed and Verex Kernel)
 *
 *  Kernel time services - machine-independent portion
 */

#include "process.h"
#include "timer.h" /* (Typically) Machine-dependent header */
#include "../../libc/include/Vioprotocol.h"

/* Static Globals containing the current time GMT in seconds and
 * clicks (clock interrupts) since January 1, 1970.
 */

struct
  {
    long    seconds;
    int    clicks;
  } Time;

Process *Delayq_head;    /* Head pointer for delay queue */

GetTime( clicksptr ) int *clicksptr;

  /* Return the current time in seconds and store
   * the current number of clicks into *clicksptr
   * if it is non-zero.
   */
  {
    register long seconds;

    disable;
    *clicksptr = Time.clicks;
    seconds = Time.seconds;
    enable;
    return( seconds );
  }

SetTime( seconds, clicks ) long seconds; int clicks;

  /* Set the current time to the specified number of seconds
   * and clicks.
   */
  {

    disable;
    Time.seconds = seconds;
    Time.clicks = clicks;
    enable;
  }

Delay( seconds, clicks ) long seconds; int clicks;

  /* Block the active process for the specified number
   * of seconds and clicks. It is assumed that the total
   * number of clicks (i.e. seconds*CLICKS_PER_SEC+clicks)
   * can be stored in a long unsigned number.
   * The number of clicks remaining in the delay time is returned,
   * which is 0 unless Wakeup has been used.
   */
  {
    extern    Process *Active, *Delayq_head, *Readyq_head;
    register Process *pd, *tmp_pd, *prev;
    register long delay_clicks;
    int GetClicksLeft();

    /* Convert seconds and clicks to clicks */
    delay_clicks = seconds*CLICKS_PER_SEC + clicks;

    if( delay_clicks == 0 ) return( 0 );

    pd = Active;
    pd->state = DELAYING;

    /* Remove from ready queue and insert in delay queue */
/*    Removeready();	Done by kernel process */

    disable;
    tmp_pd = Delayq_head;

    if( tmp_pd == NULL ) Delayq_head = pd;
    else
      if( delay_clicks < tmp_pd->blocked_on ) Delayq_head = pd;
    else
      {
        do /* Find pd's position in delay queue */
          {
            delay_clicks -= tmp_pd->blocked_on;
            prev = tmp_pd;
            tmp_pd = tmp_pd->link;
          }
        while( tmp_pd != NULL && delay_clicks >= tmp_pd->blocked_on );
        prev->link = pd;
      }
    if( (pd->link = tmp_pd) != NULL )
        tmp_pd->blocked_on -= delay_clicks;

     pd->blocked_on = delay_clicks;
  }


Wakeup( pid ) Process_id pid;

  /* Unblock the specified process providing it is blocked
   * in the delay queue.
   */
  {
    extern    Process *Delayq_head, *Pd_bundle[], *Map_pid();
    extern Process_id Kernel_Process_Pid;
    register Process *pd, *prev;
    long *msgarray;
    IoReply *iorep;

    disable;
    if( (pd=Map_to_pd(pid))->pid != pid ) return( 0 );
    if( pd->state != DELAYING ) return( 0 );

    /* Remove from delay queue */
    if( Delayq_head == pd ) Delayq_head = pd->link;
    else
      {
        prev = Delayq_head;
        while( prev->link != pd ) prev = prev->link;
        prev->link = pd->link;
      }
    /* Adjust delay times of following process if any */
    if( pd->link != NULL )
        pd->link->blocked_on += pd->blocked_on;

    enable;

    msgarray = (long *)(pd->msg);	/* What a mess */
    msgarray[3] = pd->blocked_on;  
    iorep = (IoReply *) (pd->msg);
    iorep->replycode = OK;
    pd->blocked_on = Kernel_Process_Pid;
    pd->state = AWAITING_REPLY;
    ReplyWithSegment( pd->msg, pid, NULL, NULL, 0 ); 

    return( pid );
  }

Timer_interrupt()

  /* Called on each kernel timer interrupt.
   * Several duties are performed:
   * - Increment the current time.
   * - Check and update the delay queue.
   * - Check for a process blocked on a non-existent process.
   * Before doing anything we check the value of KernelInterrupted.
   * If non-zero (meaning we have interrupted the kernel), we
   * return immediately.
   */
  {
    extern    Process *Readyq_head, *Active, *Delayq_head,
            *Pd_bundle[], *Map_pid();
    extern short KernelInterrupted;
    int Retransmit(), NetCheck();
    Process_id DestroyAlien();
    extern    struct Time;
    extern int NetAlarm;
    static int pd_index;
    register Process *pd;
    IoReply *iorep;

    /* Update the current time */
    if( ++Time.clicks > CLICKS_PER_SEC-1 )
      {
        ++Time.seconds;
        Time.clicks = 0;
      }
    if( (pd = Delayq_head) != NULL )
      {
        if( --(pd->blocked_on) != 0 ) goto check_proc;

        do /* Remove processes from delayq whose time has expired */
          {
            Delayq_head = pd->link;
            SetReturnValue( pd, 0 );
            Addready( pd ); 
            pd = Delayq_head;
          }
        while( pd != NULL && pd->blocked_on == 0 );
        return;
      }
check_proc: /* Check for processes blocked on non-existent processes */

    if( KernelInterrupted != 0 ) return;
    if( --NetAlarm == 0 ) NetCheck();
    
    pd = Pd_bundle[++pd_index&(MAX_PROCESSES-1)];

    if( pd->pid == 0 || 
	pd->blocked_on == 0 ||
	pd->state == READY || 
	pd->state == DELAYING || 
	pd->state == AWAITING_INT ) return;

    /* Local process blocked on non local process */
    if( (NonLocal(pd->blocked_on)) || (pd->state == GETPID_BLKED) )
          Retransmit(pd);
    /* Alien process */
    else if( NonLocal( pd->pid ) )
      {
	pd->numTrans--;
	if( pd->numTrans == 0 )
	    DestroyAlien( pd->pid );
	else if( pd->state == SEND_BLKED || pd->state == AWAITING_REPLY )
	    if( pd->blocked_on != 0 && Map_pid(pd->blocked_on) == NULL )
		DestroyAlien( pd->pid );
      }
    /* Local process blocked on local process */
    else if( pd->state == SEND_BLKED || pd->state == RECEIVE_BLKED ||
          pd->state == AWAITING_REPLY )
      {
        if( pd->blocked_on != 0 && Map_pid(pd->blocked_on) == NULL )
	  {
	    iorep = ( IoReply * ) (pd->msg);
	    iorep->replycode = NONEXISTENT_PROCESS;
            Addready ( pd );
 	  }
      }
}
