/*
 * Distributed V Kernel - Copyright (c) 1982 by David Cheriton, Willy Zwaenepoel
 * (Transliterated from Zed and Verex Kernel)
 *
 * Kernel naming support - very primitive
 *
 */

#include "../../libc/include/Venviron.h"
#include "process.h"
#include "naming.h"

Logical_id_entry Logical_id_map[MAX_LOGICAL_ID+1];

SetPid( logical_id, pid, scope ) 
register Process_id pid; unsigned logical_id; unsigned char scope;

  /* Set the logical id to be the specified pid.
   */
  {
    extern Logical_id_entry Logical_id_map[];

    if( logical_id > MAX_LOGICAL_ID ) return( 0 );
    Logical_id_map[logical_id].pid = pid;
    if( (scope!=LOCAL_PID) && (scope!=REMOTE_PID) && (scope!=ANY_PID) )
	scope = ANY_PID;
    Logical_id_map[logical_id].scope = scope;
    return( 1 );
  }

Process_id GetPid( logical_id, scope ) 
register unsigned logical_id; unsigned char scope;

  /* Return the pid corresponding to the logical_id.
   */
  {
    extern Process *Active;
    extern Process_id Device_Server_Pid, Kernel_Process_Pid;
    extern Logical_id_entry Logical_id_map[];
    Process_id pid;
    int NonLocalGetPid();

    if( logical_id > MAX_LOGICAL_ID ) return ( 0 );

    if( scope == LOCAL_PID || scope == ANY_PID )
      {
	/* Look for a local pid first */
	if( logical_id == ACTIVE_PROCESS ) return( Active->pid );
	if( logical_id == DEVICE_SERVER ) return( Device_Server_Pid );
	if( logical_id == KERNEL_PROCESS ) return( Kernel_Process_Pid );
        if( Logical_id_map[logical_id].scope != REMOTE_PID &&
	        ValidPid( pid = Logical_id_map[logical_id].pid ) )
	    return( pid );
      }
    if( scope == REMOTE_PID || scope == ANY_PID )
      {
	/* Then try for a remote pid */
	NonLocalGetPid( logical_id );
	return;
      }

    /* A non-valid scope, or no such local pid */
    return( 0 );
  }

