/*
 * Distributed V Kernel 
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 * (Transliterated from Zed and Verex Kernel)
 *
 * Inter-process communication primitives
 * Send, Receive, Reply, Forward, ReceiveSpecific, RewriteMsg, RereadMsg,
 * AwaitingReply
 *
 */


#include "process.h"
#include "../../libc/include/Vioprotocol.h"

extern Process *Map_pid();

Process_id Send( msg, pid ) register Unspec *msg; Process_id pid;

  /*
   * Send a message to the process specified by pid.
   */
  {
    extern Process *Pd_bundle[], *Active, *Readyq_head;
    extern Process_id Device_Server_Pid, Kernel_Process_Pid;
    register Process *receiver, *pd, *prev;
    Process_id GetReply(), NonLocalSend();
    long *msgarray;
    IoReply *iorep = ( IoReply * ) msg;

    pd = Active;

    /* Copy in message, or use contents of kernel msg buffer if null */
    if (msg != NULL)
      {
        if( BadUserPtr(msg) ) 
	  {
	    iorep->replycode = BAD_ADDRESS;
	    return( pid ); 
	  }
        Copy_in_msg( pd->msg, msg );
      }

    /* Check if there is segment associated with this message */
    msgarray = (long *) (pd->msg);
    if ( msgarray[OPCODE_INDEX] & SEGMENT_MASK )
      {
        pd->dataSegmentPro = (unsigned char)((msgarray[OPCODE_INDEX]&0xff000000)>>24);
        pd->dataSegmentPtr = (Unspec *) (msgarray[SEGMENTPTR_INDEX]);
        pd->dataExpected = NULL;
        pd->dataSegmentSize = msgarray[SEGMENTSIZE_INDEX];
	if (SegOutsideTeamSpace(pd, pd->dataSegmentPtr, pd->dataSegmentSize))
	  {
	    iorep->replycode = BAD_ADDRESS;
	    return( pid );
	  }
      }
    else
        pd->dataSegmentSize = 0;

    if( (receiver=Map_to_pd(pid))->pid != pid )
      {
	if( pid == Kernel_Process_Pid )
	  {
	    SendKernel( pd, msg );
	    return(Kernel_Process_Pid);
	  }
        if (pid == Device_Server_Pid)
          {
            SendDevice(msg);
            return(Device_Server_Pid); 
          }
        if (NonLocal(pid))
          {
            NonLocalSend(msg,pid);
            return;
          }
	iorep->replycode = NONEXISTENT_PROCESS;
        return( pid );
      }

    /* Indicate that the "forwarder" is the same as the sender */
    pd->forwarder = (Process *) pd->pid;
    pd->blocked_on = pid;
    Removeready();
    if( (receiver->state == RECEIVE_BLKED) && 
        ((receiver->blocked_on == 0) || (receiver->blocked_on == pd->pid)) )
      {
        pd->state = AWAITING_REPLY;
        receiver->blocked_on = pd->pid;
        receiver->last_sender = pd;
	if( receiver->recBufSize != 0 )
	  {
	    SetProcessContext( receiver );
	    if( pd->dataSegmentSize == 0 )
		*(receiver->recBufSizePtr) = 0;
	    else if( pd->dataSegmentSize <= receiver->recBufSize )
	      {
		if( pd->team == receiver->team )
		    Copy_bytes( receiver->recBufPtr, pd->dataSegmentPtr,
				pd->dataSegmentSize );
		else
		    InterTeamCopy( receiver->recBufPtr, receiver->team,
		    pd->dataSegmentPtr, pd->team, pd->dataSegmentSize );
		*(receiver->recBufSizePtr) = pd->dataSegmentSize;
	      }
	    else /* pd->dataSegmentSize > receiver->recBufSize */
	      {
		if( pd->team == receiver->team )
		    Copy_bytes( receiver->recBufPtr, pd->dataSegmentPtr,
				receiver->recBufSize );
		else
		    InterTeamCopy( receiver->recBufPtr, receiver->team,
		    pd->dataSegmentPtr, pd->team, receiver->recBufSize );
		/* *recBufSizePtr has the right value */
	      }
	  }
        Addready( receiver );
      }
    else
      {
        pd->link = NULL;
        pd->state = SEND_BLKED;
        receiver->msg_queue_end = ((receiver->msg_queue_end)->link = pd);
      }
    /* Arrange to get reply after unblocking */
    pd->finish_up = (Unspec (*)()) GetReply;
    pd->returnMessage = (Unspec *) msg;

  }


Process_id GetReply( msg ) register Unspec *msg;

  /* Finish up after Send() unblocks by picking up the reply
   *   and returning the pid of the recipient
   */
  {
    extern Process *Active;
    register Process *active;
    
    active = Active;
    /* The test != NULL is necessary in the case where the last
       message of this process was sent from its kernel message buffer */
    /* Caveat: remote GetPid takes advantage of this */
    if ( msg != NULL ) Copy_out_msg(msg,active->msg);
    return(active->blocked_on);
  }

#ifdef DELETED
/* Supplanted by ReceiveWithSegment */
Process_id Receive( msg ) register Unspec *msg;
  {
    extern    Process *Active;
    register Process *pd, *sender;
    Process_id GetMessage();

    pd = Active;
    if( BadUserPtr(msg) ) return( 0 );

    if( (sender = pd->msg_queue) == NULL )
      {
        pd->blocked_on = 0;
        pd->state = RECEIVE_BLKED;
	pd->recBufSize = 0;
        Removeready();

        pd->finish_up = (Unspec (*)()) GetMessage;
        pd->returnMessage = (Unspec *) msg;
      }
    else
      {
        if( (pd->msg_queue = sender->link) == NULL )
          pd->msg_queue_end = (Process *) &(pd->msg_queue);
        sender->state = AWAITING_REPLY;

        Copy_out_msg( msg, sender->msg );
        return( sender->pid );
      }
  }
#endif DELETED

Process_id ReceiveWithSegment( msg, recbufptr, recbufsizeptr ) 
register Unspec *msg;unsigned *recbufptr, *recbufsizeptr;

  /* Receive a message from any process with a specified receiver buffer.
   */
  {
    extern    Process *Active;
    register Process *pd, *sender;
    Process_id GetMessage();

    pd = Active;
    if( BadUserPtr( msg ) ||
	BadUserPtr( recbufptr ) ||
	BadUserPtr( recbufsizeptr ) )
	return( 0 );

    if( (sender = pd->msg_queue) == NULL )
      {
        pd->blocked_on = 0;
        pd->state = RECEIVE_BLKED;
	pd->recBufPtr = recbufptr;
	pd->recBufSizePtr = recbufsizeptr;
	pd->recBufSize = *recbufsizeptr;
        Removeready();

        /* Arrange to get message after unblocking */
        pd->finish_up = (Unspec (*)()) GetMessage;
        pd->returnMessage = (Unspec *) msg;
      }
    else
      {
        if( (pd->msg_queue = sender->link) == NULL )
          pd->msg_queue_end = (Process *) &(pd->msg_queue);
        sender->state = AWAITING_REPLY;

	*recbufsizeptr = 0;
        Copy_out_msg( msg, sender->msg );

        return( sender->pid );
      }
  }

Process_id ReceiveSpecific( msg, pid ) register Unspec *msg; Process_id pid;

  /* Receive a message from the specified process.
   *
   */
  {
    extern Process *Pd_bundle[], *Active, Idle_process;
    register Process *sender, *active, *pd;
    Process_id GetMessage(), NonLocalReceiveSpecific();
    Process *FindAlien();

    if( BadUserPtr(msg) ) return( 0 );

    active = Active;

    if( ( (sender=Map_to_pd(pid))->pid != pid  ) &&
	( ( (sender=FindAlien(pid)) == NULL ) ||
	  ( sender->state == REPLIED_TO )
	)
      )
      {
        if (NonLocal(pid))
          {
            NonLocalReceiveSpecific(msg,pid);
            return;
          }
        return(0);
      }
    if( (sender->state != SEND_BLKED) || (sender->blocked_on != Active->pid) )
      {
	active->last_sender = &Idle_process;
        active->blocked_on = pid;
        active->state = RECEIVE_BLKED;
	active->recBufSize = 0;  /* no segment buffer */
        Removeready();

        /* Arrange to get message after unblocking */
        active->finish_up = (Unspec (*)()) GetMessage;
        active->returnMessage = (Unspec *) msg;
        return;
      }
    if( (pd = active->msg_queue) == sender )
      {
        if( (active->msg_queue = sender->link) == NULL )
            active->msg_queue_end = (Process *) &(active->msg_queue);
      }
    else
      {
        while( pd->link != sender ) pd = pd->link;
        if( (pd->link = sender->link) == NULL )
            active->msg_queue_end = pd;
      }
    sender->state = AWAITING_REPLY;
    Copy_out_msg( msg, sender->msg );
    return( pid );
  }

Process_id GetMessage( msg ) register Unspec *msg;

  /* Finish up after Receive() or ReceiveSpecific() unblocks by picking
   *   up the message if the sender has not died, and returning its pid.
   *   If the sender has died and this was Receive(), the library routine
   *   for Receive() must detect the 0 return value and repeat the trap.
   */
  {
    extern Process *Active;
    register Process *active, *sender;
    register Process_id blocked_on;

    active = Active;
    blocked_on = active->blocked_on;
    if ((sender = active->last_sender)->pid != blocked_on)
        return(0); /* Sender dead */

    Copy_out_msg(msg,sender->msg);
    return(blocked_on);
  }

#ifdef DELETED
/* Supplanted by ReplyWithSegment */
Process_id Reply( msg, pid ) register Unspec *msg; Process_id pid;
  {
    extern Process *Pd_bundle[], *Active;
    extern Process_id Kernel_Process_Pid;
    register Process *sender;
    Process_id NonLocalReply();

    if( (sender=Map_to_pd(pid))->pid != pid )
      {
        if (NonLocal(pid))
          {
            NonLocalReply(msg,pid);
            return(pid);
          }
        return(0);
      }

    if( (sender->state != AWAITING_REPLY) || 
	( (sender->blocked_on != Active->pid) &&
	  (sender->blocked_on != Kernel_Process_Pid) ) )
      {
        return( 0 );
      }
    Copy_in_msg( sender->msg, msg );
    Addready( sender );
    return( pid );
  }
#endif DELETED

Process_id ReplyWithSegment( msg, pid, src, dest, bytes )
Unspec *msg; Process_id pid; unsigned char *src, *dest; unsigned bytes;
  /*
   * Add segment to Reply
   */
  {
    extern Process *Active;
    Process_id NonLocalReplyWithSegment();
    register Process *sender;
    Process *active;

    active = Active;
    if( (sender=Map_to_pd(pid))->pid != pid )
      {
	if( NonLocal( pid ) )
	  {
	    NonLocalReplyWithSegment( msg, pid, src, dest, bytes );
	    return;
	  }
	return( 0 );
      }

    if( (sender->state != AWAITING_REPLY) || 
        ( (sender->blocked_on != active->pid)  &&
	  (sender->blocked_on != Kernel_Process_Pid) ) )
	return( 0 );

    if( bytes == 0 )
      {
	Copy_in_msg( sender->msg, msg );
	Addready( sender );
	return( pid );
      }

    if( ((sender->dataSegmentPro & WRITE_ACCESS) == 0) ||
        ((unsigned)sender->dataSegmentPtr > (unsigned)dest) ||
        ((unsigned)dest+bytes >
         (unsigned)(sender->dataSegmentPtr)+sender->dataSegmentSize)
      )
        return( 0 );

    if( (sender->team == active->team) ||	 /* Straight copy */
	(sender->blocked_on == Kernel_Process_Pid) )
      {
        if( BadUserPtr(dest) ) return( BAD_BUFFER );
        Copy_bytes( dest, src, bytes );
      }
    else  /* Inter-team copy */
      {
        if( BadUserPtr(dest) ) return( BAD_BUFFER );  /* (?) */
        InterTeamCopy(dest,sender->team, src,active->team, bytes);
      }
    Copy_in_msg( sender->msg, msg );
    Addready( sender );
    return( pid );
  }

Process_id Forward( msg, from_pid, to_pid ) Unspec *msg;
                        Process_id from_pid, to_pid;
  /* Forward from_pid to to_pid with the specified message.
   *
   */
  {
    extern Process *Pd_bundle[], *Active, *Readyq_head;
    extern Process_id Device_Server_Pid, Kernel_Process_Pid;
    register Process *sender, *receiver, *prev;
    Process_id NonLocalForward1(), NonLocalForward2();

    if( (sender=Map_to_pd(from_pid))->pid != from_pid )
      {
        if (NonLocal(from_pid))
          {
            NonLocalForward1(msg,from_pid,to_pid);
            return(to_pid); /* Flaky, can't check whether to_pid exists */
          }
        return(0);
      }
    if( (sender->state != AWAITING_REPLY) || 
	( (sender->blocked_on != Active->pid) &&
	  (sender->blocked_on != Kernel_Process_Pid) )
      )
        return( 0 );
    sender->forwarder = (Process *) sender->blocked_on;

    if( (receiver=Map_to_pd(to_pid))->pid != to_pid )
      {
        if (to_pid == Device_Server_Pid)
          {
            /* Forward to device server */
            Copy_in_msg(sender->msg,msg);
            sender->finish_up = (Unspec (*)()) SendDevice;
	    Addready(sender);
            return (to_pid);
          }
        if (NonLocal(to_pid))
          {
            NonLocalForward2(msg,from_pid,to_pid);
            return( to_pid ); /* equally flaky */
          }
        /* Add from_pid to readyq before returning */
	sender->blocked_on = to_pid;
	((IoReply *)sender->msg)->replycode = NONEXISTENT_PROCESS;
        Addready(sender);
        return(0);
      }

    Copy_in_msg( sender->msg, msg );

    if( (receiver->state == RECEIVE_BLKED) &&
        ((receiver->blocked_on == 0) || (receiver->blocked_on == from_pid)) )
      {
        sender->blocked_on = to_pid;
        sender->state = AWAITING_REPLY;
        receiver->blocked_on = from_pid;
        receiver->last_sender = sender;
	if (receiver->recBufSize != 0)
	  {
	    SetProcessContext(receiver);
	    *(receiver->recBufSizePtr) = 0;
	  }
        Addready( receiver );
      }
    else
      {
	sender->link = NULL;
        sender->blocked_on = to_pid;
        sender->state = SEND_BLKED;
        receiver->msg_queue_end = (receiver->msg_queue_end)->link
                    = sender;
      }
    return( to_pid );
  }

#ifdef DELETED
/* No longer available */
Process_id RewriteMsg( msg, pid ) register Unspec *msg; Process_id pid;
  {
    extern Process *Active;
    register Process *pd;
    Process *GetAlien(); 

    if( BadUserPtr(msg) )
	return( 0 );
    if( pid == 0 )
      {
        pd = Active;
        pid = pd->pid;
      }
    else
      {
        if( (pd=Map_to_pd(pid))->pid != pid )
          {
	    if( !NonLocal(pid) || ((pd=GetAlien(pid)) == NULL) )
		return( 0 );
	  }
    
        if( pd->state != AWAITING_REPLY || pd->blocked_on != Active->pid )
            return( 0 );
      }
    Copy_in_msg( pd->msg, msg );
    return( pid );
  }
#endif DELETED

Process_id RereadMsg( msg, pid ) register Unspec *msg; Process_id pid;
  {
    extern Process *Pd_bundle[], *Active;
    Process *GetAlien();
    register Process *pd;

    if( BadUserPtr(msg) ) return( 0 );
    
    if( pid == 0 )
      {
        pd = Active;
        pid = pd->pid;
      }
    else
      {
        if( (pd=Map_to_pd(pid))->pid != pid )
	  {
	    if( !NonLocal(pid) || (pd=GetAlien(pid)) == NULL )
		return( 0 );
	  }

        if( pd->state != AWAITING_REPLY || pd->blocked_on != Active->pid )
            return( 0 );
      }
    Copy_out_msg( msg, pd->msg );
    return( pid );
  }

SystemCode MoveTo( dest_pid, dest, src, bytes )
  Process_id dest_pid; unsigned bytes;
                register Unspec *dest, *src;
  /* Move bytes bytes from src in the active process's space to
   * dest in the space of dest_pid, providing it is awaiting reply
   * from the active process.
   */
  {
    extern Process *Pd_bundle[], *Active;
    register Process *active, *pd;
    Process_id NonLocalMoveTo();

    active = Active;

    if( SegOutsideTeamSpace(active, src, bytes) )
	return( BAD_BUFFER );

    if( (pd = Map_to_pd(dest_pid))->pid != dest_pid )
      {
        if (NonLocal(dest_pid))
          {
	    if( bytes <= 0 ) return( OK );
            NonLocalMoveTo( dest_pid, dest, src, bytes );
            return; /* Return value set by finish up function */
          }
        return( NONEXISTENT_PROCESS );
      }

    if( (pd->state != AWAITING_REPLY) || 
        (pd->blocked_on != active->pid) )
        return( NOT_AWAITINGREPLY );

    if( ((pd->dataSegmentPro & WRITE_ACCESS) == 0) )
	return( NOT_WRITEABLE );

    if( ((unsigned)pd->dataSegmentPtr > (unsigned)dest) ||
        ((unsigned)dest+bytes >
         (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize) )
	return( BAD_ADDRESS );

    if( pd->team == active->team ) /* Straight copy */
      {
        Copy_bytes( dest, src, bytes );
        return( OK );
      }
    else  /* Inter-team copy */
      {
        InterTeamCopy(dest,pd->team, src,active->team, bytes);
        return( OK );
      }
  }

MoveFrom( src_pid, dest, src, bytes ) Process_id src_pid; unsigned bytes;
                register Unspec *dest, *src;
  /* Move bytes bytes from src in the src_pid process's space to
   * dest in the space of active process, providing src_pid is awaiting reply
   * from the active process.
   */
  {
    extern Process *Pd_bundle[], *Active;
    register Process *active, *pd;
    Process_id NonLocalMoveFrom();

    active = Active;

    if( SegOutsideTeamSpace(active, dest, bytes) )
	return( BAD_BUFFER );

    if( (pd = Map_to_pd(src_pid))->pid != src_pid )
      {
        if (NonLocal(src_pid))
          {
            NonLocalMoveFrom( src_pid, src, dest, bytes );
            return; /* Return value set by finish up function */
          }
        return( NONEXISTENT_PROCESS );
      }

    if( (pd->state != AWAITING_REPLY) || 
        (pd->blocked_on != active->pid) )
	return( NOT_AWAITINGREPLY );

    if( ((pd->dataSegmentPro & READ_ACCESS) == 0) )
	return( NOT_READABLE );

    if( ((unsigned)pd->dataSegmentPtr > (unsigned)src) ||
        ((unsigned)src+bytes >
         (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize) )
        return( BAD_ADDRESS );

    if( pd->team == active->team ) /* Straight copy */
      {
        Copy_bytes( dest, src , bytes );
        return( OK );
      }
    else  /* Inter-team copy */
      {
        InterTeamCopy(dest,active->team, src,pd->team, bytes);
        return( OK );
      }

  }

