/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Kernel Initialization Routines - machine-independent
 *
 */

#include "process.h"
#include "dm.h"
#include "naming.h"

#define KFREE_LIST (sizeof(Process)*MAX_PROCESSES+sizeof(Team)*MAX_TEAMS)

#define DFREE_LIST (sizeof(DeviceInstance)*MAX_DEVICES)

char Kernel_free_list[KFREE_LIST]; /* Raw kernel memory fo TD's and PD's */

char Device_free_list[DFREE_LIST]; /* Raw kernel memory for Device descs */

Process Idle_process; /* Process descriptor for idle pseudo-process */

Process *Pd_bundle[MAX_PROCESSES]; /* Edge vector of PD's */

Process *Ad_bundle[MAX_PROCESSES]; /* Edge vector of aliens */

Process *Moveq_head, *Moveq_tail; /* Q for blocks to be moved */

unsigned LogicalHostNumber; /* This is the logical host number
				   shifted by 16 bits to the left */

Process_id Device_Server_Pid; /* Kernel device server pid */
Process_id Kernel_Process_Pid; /* Kernel process pid */

extern Logical_id_entry Logical_id_map[];

short KernelInterrupted;  /* A non-zero value indicates that an
			     interrupt routine interrupted a
			     kernel operation */

Init_kernel()

  /* First entry point for kernel initialization.
   *
   */
  {
    extern Process *Pd_bundle[], *Active, *Readyq_head, *Delayq_head,
	  Idle_process, *Last_free_pd, *Free_pds, *Last_free_ad, *Free_ads;
    extern Process_id Device_Server_Pid;
    extern Team *Teams;
    extern DeviceInstance *DeviceTable[];
    register Team *td, *last_td;
    register Process *pd, *ad;
    register DeviceInstance *di;
    register unsigned i;

    Init_memory_mapping();

    /* Allocate required number of team descriptors */
    td = (Team *) &Kernel_free_list[0];
    last_td = (Team *) &Teams;
    for( i = 0; i < MAX_TEAMS; ++i )
      {
	last_td->link = td;
	td->link = NULL;
	td->team_root = 0;
	last_td = td;
	Ms_td_init( td, i );
	++td;
      }
    /* Allocate the required number of process descriptors
     * and perform some initialization.
     */
    pd = (Process *) td;
    Last_free_pd = (Process *) &Free_pds;
    LogicalHostNumber = ((unsigned) GetLogicalHost())<<16;
    for( i = 0; i < MAX_PROCESSES; ++i )
      {
	Pd_bundle[i] = pd;
	Last_free_pd = (Last_free_pd->link = pd);
	pd->link = NULL;
	pd->pid = 0;
	pd->old_pid = LogicalHostNumber + i; /* distributed ipc */
	Ms_pd_init( pd, i );
	++pd;
      }

    /* Set device server pid */
    Device_Server_Pid = LogicalHostNumber + LOCAL_DEVICE_SERVER_PID;
    Kernel_Process_Pid = LogicalHostNumber + LOCAL_KERNEL_PROCESS_PID;

    /* Initialize alien table */
    for( i = 0; i < MAX_PROCESSES; ++i )
	Ad_bundle[i] = NULL;

    /* Initialize the device descriptors */
    di = ( DeviceInstance * ) &Device_free_list[0];
    for ( i = 0; i < MAX_DEVICES; ++i )
      {
	DeviceTable[i] = di;
	di->id = i + MAX_DEVICES;	/* make sure 0 is invalid */
	di->owner = 0;
	di->reader = 0;
	di->writer = 0;
	++di;
      }

    /* Initialize the idle process */
    pd = Readyq_head = &Idle_process;
    Active = pd;
    pd->link = NULL;
    pd->pid = 0; /* Invalid process id */
    pd->father = NULL;
    pd->brother = NULL;
    pd->son = NULL;
    pd->state = READY;
    pd->priority = NULL_PROCESS_PRIORITY; /* Lowest priority*/
    pd->team = Teams;	/* Put on first team, when created */

    /* Initialize Qs */
    Delayq_head = NULL;
    Moveq_head = NULL;
    Moveq_tail = (Process *) &Moveq_head;

    /* Put pointers in place for use by postmortem debugger */
    P_Pd_bundle = &(Pd_bundle[0]);
    P_Active = &Active;
    P_Readyq_head = &Readyq_head;
    P_Delayq_head = &Delayq_head;

    Powerup();

    Init_root_team();

    Idle();		/* Now function as the idle process */
  }
