/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Kernel device management: header file.
 */

#ifndef DM
#define DM

#include "../../libc/include/Vioprotocol.h"
#include "../m68k/config.h"

typedef struct
  {
    InstanceId		id;		/* File or device instance id */
    ProcessId		owner;		/* Owner process */
    unsigned		blocksize;	/* Max. block size */
    unsigned short	type;
    unsigned short	lastbytes;
    unsigned		lastblock;
    unsigned		nextblock;
    SystemCode		(*readfunc)();	/* Device-dependent functions */
    SystemCode		(*writefunc)();
    SystemCode		(*modifyfunc)();
    SystemCode		(*queryfunc)();
    SystemCode		(*releasefunc)();
    ProcessId		reader;
    ProcessId		writer;
    char		*devicedesc;	/* Device-specific additional info */
  } DeviceInstance;

#endif
