/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 *  Kernel trap handler for process-invoked traps.
 *  Changes to this file need to be coordinated with
 *  the C kernel trap definitions for programs.
 */
#define ValidPid Map_pid

typedef int (*PFI)();			/* Ptr to fn (returning int)   */
extern int				/* Internal names of functions */
	Forward(),
	GetPid(),
	MoveFrom(),
	MoveTo(),
	ReceiveSpecific(),
	RereadMsg(),
	Send(),
	ReceiveWithSegment();
	ReplyWithSegment();

#define kernelop(name,Asm_name_trap)				\
								\
asm("	.text");						\
asm("	.globl	Asm_name_trap");				\
asm("Asm_name_trap:");						\
asm("	orw #/0100,sr");					\
asm("	moveml #/40f0,sp@-");					\
asm("	jbsr name");						\
asm("	addl #20,sp");						\
asm("	orw #/0700,sr");					\
asm("	movl Active,a0");					\
asm("	jmp	Switch");					\
asm("	rte");							\
int Asm_name_trap();

kernelop(Forward,Asm_Forward_trap)
kernelop(GetPid,Asm_GetPid_trap)
kernelop(MoveFrom,Asm_MoveFrom_trap)
kernelop(MoveTo,Asm_MoveTo_trap)
kernelop(ReceiveSpecific,Asm_ReceiveSpecific_trap)
kernelop(ReceiveWithSegment,Asm_ReceiveWithSegment_trap)
kernelop(RereadMsg,Asm_RereadMsg_trap)
kernelop(ReplyWithSegment,Asm_ReplyWithSegment_trap)
kernelop(Send,Asm_Send_trap)
