/*
 * Mouse handling routines for the SMI mouse.
 * The SMI mouse has to be polled every 2 ms.  To do this, the kernel has
 * been changed to have a timer interrupt every 2 ms instead of every 10 ms
 * if running on an SMI workstation.  The normal interrupt activities are 
 * done once every 5 interrupts to preserve the previous semantics.
 * SmiMouseInterrupt is called on every timer interrupt to update the mouse
 * status.
 * -Marvin Theimer, 2/83.
 */


extern short MouseEvent, MouseX, MouseY;
extern short unsigned MouseButtons;

#define Port (*(short *)(0xE00000))

static short cur = 0, prev = 0;
static short unsigned oldButtons = 0;


SmiMouseInterrupt()
  {
    char dx, dy;

    cur = Port & 0xff;
    if (cur == prev)
        return;
    if ((cur & 0xf0) == 0x80)
      {
        dy = prev;
	dy >>= 1;
	if (dy < -40) dy = 0;
	MouseY -= dy;			/* NOTE the minus sign */
	MouseButtons = (short unsigned) ((cur>>1) & 7);
        MouseButtons = ((MouseButtons & 4) >> 2) | ((MouseButtons & 3) << 1);
	if (dy || (MouseButtons != oldButtons))
	    MouseEvent = 1;
	oldButtons = MouseButtons;
      }
    else if ((prev & 0xf0) == 0x80)
      {
        dx = cur;
	dx >>= 1;
	if (dx < -40) dx = 0;
	MouseX += dx;
	if (dx) 
	    MouseEvent = 1;
      }
    prev = cur;
  }
