/*
 * V Kernel - Copyright (c) 1982 by David Cheriton, Tim Mann
 * (Transliterated from Zed and Verex Kernel)
 *
 * Header file describing Sun memory mapping
 */

#ifndef MEMORY
#define MEMORY

#define PAGESIZE	2048
#define SEGSIZ		0x8000
#define PGPERSEG	(SEGSIZ/PAGESIZE)
#define PHYSSEGS	64
#define KSTART		0x1000     /* Kernel is loaded at this address */
#define TSTART		(2*SEGSIZ) /* Use SEGSIZ if kernel is only 1 seg */
#define TLIMIT		0x1C0000   /* Start of frame buffer (normally) */
#define MBMEM		0x100000   /* Sun Monitor maps Multibus memory here */
#define MBIO		0x1F0000   /* Sun Monitor maps Multibus I/O here */
#define MEMLIMIT	0x200000   /* End of mappable address space */
#define ADDRLIMIT	0x1000000  /* Limit of 24-bit MC68000 address space */
#define XFERSEG		0x1E8000   /* Segment used for interteam copies */

#define TESTPAGE 	XFERSEG    /* Used during memory size test */

#define MAX_ONBOARD_PAGES (1<<12)  /* 12-bit field */
#define MAX_MULTIBUS_PAGES (TLIMIT/PAGESIZE)
				   /* Assume no MB memory past standard
					framebuffer location */

/* Page map entries */
#define PAGETYPE	(3<<12)	   /* Mask to get page type field */
#define ONBOARD		(0<<12)	   /* "Onboard" physical address space */
#define NONEXIS		(1<<12)    /* Nonexistent */
#define MULTMEM		(2<<12)    /* Multibus memory address space */
#define MULTIO		(3<<12)    /* Multibus I/O address space */
#define NOPAGE		NONEXIS

typedef short unsigned PageMapEntry;
typedef short unsigned SegMapEntry;

typedef union
  {
    PageMapEntry nextpage;
    char byte[PAGESIZE];
    short word[PAGESIZE/2];
    long longword[PAGESIZE/4];
  } Page;

typedef union
  {
    char byte[SEGSIZ];
    short word[SEGSIZ/2];
    long longword[SEGSIZ/4];
  } Segment;

#define NUMCTXS 16
#define NUMSEGS 64

/* Segment map */
#define SEGMAP	 0x0FFF		/* Mask off context register */
#define PERMMASK 0x0F00		/* See only permission field */
#define PermissionField(x) ( (x&PERMMASK)>>8 )

/* Permission types */
#define ______ (0<<8)
#define __X___ (1<<8)
#define R_____ (2<<8)
#define R_X___ (3<<8)
#define RW____ (4<<8)
#define RWX___ (5<<8)
#define R__R__ (6<<8)
#define RW_R__ (7<<8)
#define R__RW_ (8<<8)
#define RW_RW_ (9<<8)
#define RW_R_X (10<<8)
#define RW_RWX (11<<8)
#define R_XR_X (12<<8)
#define RWXR_X (13<<8)
#define RWX__X (14<<8)
#define RWXRWX (15<<8)
#define UNUSED ______

/* Bits in permission translation table */
#define SR 040
#define SW 020
#define SX 010
#define UR 004
#define UW 002
#define UX 001

/* Get the current context */
#define getcontext() (*((short *) 0xC00000) >> 12)
/* Set the current context */
#define setcontext(cxt) *((short *) 0xE00000) = (cxt) << 12
/* Access the segment map entry for a given page */
#define segmap(pgaddr) \
  *((PageMapEntry *) (0xC00000 + ((long unsigned) pgaddr&~1)))
/* Access the page map entry for a given page */
#define pgmap(pgaddr)  \
  *((PageMapEntry *) (0xA00000 + ((long unsigned) pgaddr&~1)))

/* Round an address up to the next page boundary */
#define uptopage(addr)\
 ((Page *) (((((long unsigned) (addr)) - 1) & (~(PAGESIZE-1))) + PAGESIZE))
/* Round an address up to the next segment boundary */
#define uptoseg(addr)\
 ((Page *) (((((long unsigned) (addr)) - 1) & (~(SEGSIZ-1))) + SEGSIZ))

#endif
