/*
 * Distributed V Kernel
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 * (Transliterated from Zed and Verex Kernel)
 *
 * Machine-dependent kernel routines
 */
#include "../mi/process.h"
#include "../m68k/memory.h"

/* Basic Process Implementation */

dummySwitch()

  /* Save the state of the active process and
   * activate the process specified by Readyq_head,
   * loading its state from its process descriptor.
   * It is assumed to be called with interrupts disabled.
   * Switch is never called as a function; it is jumped
   * to.  The code is written inside this dummy function
   * body to allow C statements as well as asms to be
   * used.
   */
  {
    extern Unspec a0;
    extern Process *Active, *Readyq_head;
    register Process *pd;
    register Processor_state *state;
    register Unspec (*finish_up)();

    asm("    .text");
    asm("    .globl    Switch");
    asm("Switch:");

    asm("    movl    a0,sp@-");    /* Temp save a0 */
    asm("    movl    d0,sp@-");    /* Temp save d0 */
    /* Get address to use for state (destroying d0) */
    a0 = (Unspec) &(Active->proc_state);
    asm("    movl    sp@+,d0");    /* Restore d0 */
    asm("    moveml    #/7FFF,a0@");    /* Save registers in pd */
    asm("    movl    sp@+,a0@(32)");    /* ...including d0 */
    /* Save user SP as register A7--kernel SP not saved */
    asm("    movl    usp,a1");
    asm("    movl    a1,a0@(60)");
    /* Save user's sr and pc */
    /* Code depends on field order in pd */
    asm("    movw    sp@+,a0@(64)");     /* Save sr */
    asm("    movl    sp@+,a0@(66)");  /* Save pc */

newprocess:
    pd = Readyq_head;    /* Find process to switch to */
    Active = pd;
    state = &(pd->proc_state);

    /* Change to new context */
    *((short *) 0xE00000) = state->context;

    /* Call a function to finish up if necessary */
    if( finish_up = pd->finish_up )
      {
        asm( "    movw    #/2100, sr" ); /* Ensure running at kernel disable level */
        pd->finish_up = NULL;
        /* Return value in d0 */
        state->regs[0] = (*finish_up)(pd->returnMessage);
        /* Check in case we are no longer ready */
        disable;
        if( Active != Readyq_head ) goto newprocess;
      }

    /* Set the per-process data area pointer */
    if (state->perProcessLoc)
	*state->perProcessLoc = state->perProcess;
    
    a0 = (Unspec) state;
    /* Restore user's sr and pc */
    asm("    movl    a0@(66),sp@-");  /* Restore pc */
    asm("    movw    a0@(64),sp@-");     /* Restore sr */
    asm("    movl    a0@(60),a1");     /* Restore usp */
    asm("    movl    a1,usp");
    asm("    moveml    a0@,#/00FF");     /* Restore data registers */
    asm("    moveml    a0@(36),#/7E00"); /* Restore address registers */
    asm("   movl    a0@(32),a0");     /* Restore a0 */

    asm("    rte");             /* Switch to user process */
  }

/* Inter-process Communication */

 Copy_in_msg( msg_buf, msg ) register long *msg_buf, *msg;

  /* Copy message into kernel message buffer
   */
  {
    /* Warning: specialized to the messages being 8 long words */
    *msg_buf++ = *msg++;
    *msg_buf++ = *msg++;
    *msg_buf++ = *msg++;
    *msg_buf++ = *msg++;
    *msg_buf++ = *msg++;
    *msg_buf++ = *msg++;
    *msg_buf++ = *msg++;
    *msg_buf   = *msg;
  }
Copy_out_msg( msg, msg_buf ) register long *msg, *msg_buf;

 /* Copy from kernel msg buffer into msg.
  */
  {
    /* Warning: specialized to 8 long word messages */
    *msg++ = *msg_buf++;
    *msg++ = *msg_buf++;
    *msg++ = *msg_buf++;
    *msg++ = *msg_buf++;
    *msg++ = *msg_buf++;
    *msg++ = *msg_buf++;
    *msg++ = *msg_buf++;
    *msg   = *msg_buf;
  }
Copy_bytes( dest, src, bytes ) register long *dest, *src;
                    unsigned bytes;
  /* Copy bytes between same address space.
   */
  {
    register unsigned chunks, leftover, alignment;
    register char *destb, *srcb;

    alignment = (((int)dest)&1) + (((int)src)&1);
    if( alignment == 0 )
        chunks = bytes>>3; /* Copy a chunk of 8 bytes at a time */
    else if ( alignment == 2 && bytes)
      {
        *((char *) dest) = *((char *) src);
        dest = (long *) (((char *) dest) + 1);
        src = (long *) (((char *) src) + 1);
        bytes--;
        chunks = bytes>>3; /* Copy a chunk of 8 bytes at a time */
      }
    else chunks = 0;

    leftover = bytes - (chunks<<3);

    while( chunks-- )
      {
        *dest++ = *src++;
        *dest++ = *src++;
      }
    destb = (char *) dest;
    srcb  = (char *) src;
    while( leftover-- ) *destb++ = *srcb++;
  }

/* Process Management */

Ms_CreateProcess( pd, entry, stack ) register Process *pd;
                    Unspec entry; Unspec stack;

  /* Perform the machine-specific portion of process creation,
   * namely initializing the state and such like.
   */
  {
    register Processor_state *state;

    state = &(pd->proc_state);
    state->USER_STACK_POINTER = (Unspec) stack;
    state->context = pd->team->team_space.context << 12;

    state->regs[14] = 0;  /* Set initial frame pointer to 0 */
    state->sr = 0;        /* Set initial value of status register */
    state->pc = entry;    /* Set entry point */

    /* Grant creator full access to team space */
    pd->dataSegmentPro = READ_ACCESS + WRITE_ACCESS;
    pd->dataSegmentPtr = (Unspec *) TSTART;
    pd->dataSegmentSize = TLIMIT - TSTART;
  }

Ms_CreateTeam( td, pd ) register Process *pd; register Team *td;

  /* Perform the machine-specific portion of team creation.
   *
   */
  {
    register Team_space *space;
    register Processor_state *state;

    space = &(td->team_space);
    state = &(pd->proc_state);
    state->context = space->context << 12; /* For fast process switching */

    KSetTeamSize(td,NULL);	/* Be sure team space is null */

  }

/* Kernel Initialization */

#include <b.out.h> /* Initially use the standard b.out header */

Init_root_team()

  /* Create the first or root team and first process
   */
  {
    extern Team *Teams;
    register Process_id pid;
    extern struct bhdr TeamBheader;
    register char *teamsize;
    register Process *pd;
    Processor_state state;

    /* Assume first team is already loaded at TSTART */
    teamsize = (char *) TSTART + TeamBheader.tsize
         + TeamBheader.dsize + TeamBheader.bsize + INIT_STACK;

    /* Make first team root field non-zero
     *  so it will be used for first CreatTeam */
    Teams->team_root = -1;
    if( (pid = CreateTeam(ROOT_PRIORITY, 
	    TeamBheader.entry, teamsize-16)) == 0 )
        Kabort( "first team" );

    pd = (Process *) Map_pid( pid );
    pd->team->team_space.size = teamsize;

    Addready( pd ); /* First process is readied */

    CreateStdIo( pd );
  }

Ms_td_init( td, i ) register Team *td; register unsigned i;

  /*
   * Perform machine-specific initialization of team descriptors
   */
  {
    td->team_space.context = i; /* Set the context number */
    td->team_space.size = (char *) TSTART; /* Set the initial size */
  }

/* See machine.h for Ms_pd_init */

Powerup()

  /* Perform all device initializations and such like
   * as is required initially and logically after a powerup
   * after power failure.
   */
  {
    extern Process *Readyq_head;

    disable;
    FindWsType();
    InitException();
/*    Init_kernel_trap();	*/
    Init_timer();
    Init_serial_interface( 0 );
    EnetPowerup();
  }


char *StackBottom;    /* Used to clean up stack */

Idle()

  /* Idle process function. Wait for an interrupt and
   * loop as soon as redispatched.
   */
  {
    /* Initialization */
    asm("    movl    #loop,sp@-");    /* Set up for rte to loop */
    asm("    movw    #/2000,sp@-");
    asm("    movl    sp,StackBottom");
    asm("    jmp    Switch");    /* Switch to head of readyq */
    asm("loop:");

loop:    asm("    stop    #/2000");
    goto loop;
  }

/*
Init_kernel_trap()
  {
    extern int Asm_kernel_trap();
    register int (**trap_vec)() = (int(**)()) 0x80;

    *trap_vec = Asm_kernel_trap;
  }
*/
Kabort( str ) register char *str;

  /* Kernel abort: print message on console and stop with
   * only refresh interrupt enabled.
   */
  {
    extern short WsType;

    if (WsType == CADLINC) lineput( 0, '`' ); /* Turn off mouse */
    Kput_str( "Kernel abort: " ); Kput_str( str ); Kput_str( "\n" );
loop:
    asm("    stop #/2700" ); /* This allows only refresh interrupts */
    goto loop;
  }
Kput_str( str ) char *str;

  /* Output a string busy wait on the console from the kernel.
   */
  {
    register char c;

    while( c = *str++ ) emt_putchar( c );
  }

short WsType;
FindWsType()
    /*
     * Determine make of workstation.  Information used by device routines.
     */
  {
    short version;

    version = emt_version();
    if ( version == 101 || version == 0x200 )
	WsType = SMI;	/* our PROMs for SMIs are version 0.101 or 2.0 */
    else if ( ((GetConfig()>>11) & 3) == 2 )
	WsType = CADLINC;  /* only CadLinc uses 811 baud keyboard */
    else
	WsType = STANFORD; /* otherwise, one of the old homebrew Suns */
  }


