/*
 * Distributed V Kernel 
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 *
 * Kernel Ethernet driver
 * *** TPM 11/05/83 - Put in changes to make it compile, but who
 *	knows if it will run.
 */

#include "../../libc/include/Vethernet.h"
#include "../../libc/include/Vikc.h"
#include "interrupt.h"
#include "ether10meg.h"
#include "../mi/dm.h"
#undef forwarder

typedef Process_id (*PFPID)();

/* Imports */
extern Process *Map_pid();
extern SystemCode NotSupported();
extern DeviceInstance *GetDevice();

/* Exports */

extern SystemCode EnetCreate();
extern SystemCode EnetRead();
extern SystemCode EnetWrite();
extern SystemCode EnetQuery();
extern SystemCode EnetRelease();
extern SystemCode EnetCheckRequest();
extern SystemCode EnetReadPacket();
extern SystemCode EnetPowerup();

NetAddress	EnetHostNumber;		/* physical ethernet address */
DeviceInstance	*EthernetInstance = NULL;	/* ptr to DeviceInstance for Ethernet */
ProcessId	EnetWriter;		/* Non-zero if a writer using Ethernet */
int		EnetReceiveMask = ENET_DEFAULT_MASK;	/* addresses to listen for */
int		EnetBadCounts = 0;	/* Number of bad count values */
short		EnetCollisions = 0;	/* Number of collision errors */
short		EnetOverflows = 0;	/* Queue overflow errors */
short		EnetCRCerrors = 0;	/* Packets with bad CRC's */
short		EnetSyncErrors = 0;	/* Receiver out of sync */
short		EnetTimeouts = 0;	/* Transmitter timeouts */
int		EnetValidPackets = 0;
int		NetAlarm = 0;

EnetBlock	*EnetPacket;
kPacket		*kPacketSave; /* Save area for kernel packets */

NetAddress    HostAddress[] =
		{ 
		  { 0xffff, 0xffff, 0xffff }, /* Broadcast address */
		  { 0x0260, 0x8c00, 0x5953 },
		  { 0x0260, 0x8c01, 0x0297 },
		  { 0x0000, 0x0000, 0x0000 }
		};

unsigned short GetLogicalHost()

  /* Return the logical host number of this workstation */
  {
    register short *addr, *ramaddr;
    register unsigned char logicalhost;

    if( EnetHostNumber.addrlow == 0 )
      {
	addr = (short *)MEADROM;
	ramaddr = (short *)MEADRAM;
	EnetHostNumber.addrhigh = *ramaddr++ = *addr++;
	EnetHostNumber.addrmid = *ramaddr++ = *addr++;
	EnetHostNumber.addrlow = *ramaddr = *addr;
      }
    logicalhost = 0;
    while( HostAddress[++logicalhost].addrhigh != 0 )
      {
	if( EnetHostNumber.addrlow == HostAddress[logicalhost].addrlow
	    && EnetHostNumber.addrmid == HostAddress[logicalhost].addrmid
	    && EnetHostNumber.addrhigh == HostAddress[logicalhost].addrhigh )
	   return( logicalhost );
      }
    return( 0x55 );
  }

/* Macro expansion to interrupt-invoked C call to Ethernetinterrupt */
Call_inthandler(EnetInterrupt)

SystemCode EnetCreate( req, desc )
  CreateEnetRequest *req;
  DeviceInstance *desc;
  /* Create an instance for the Ethernet interface.
   */
 {
    int	receiveMask;
    register CreateInstanceReply *reply = (CreateInstanceReply *) req;

    if( req->filemode != FCREATE ) return( MODE_NOT_SUPPORTED );

    if( EthernetInstance != NULL && Map_pid(EthernetInstance->owner) )
	return( BUSY );

    /*
     * Initialize the device instance descriptor, can assume all fields
     * are zero except for owner and id.
     */

    desc->readfunc = EnetRead;
    desc->writefunc = EnetWrite;
    desc->modifyfunc = NotSupported;
    desc->queryfunc = EnetQuery;
    desc->releasefunc = EnetRelease;
    desc->reader = 0;
    desc->writer = 0;

    EthernetInstance = desc; /* Record the instance for interrupt routine */

    desc->type = (READABLE+WRITEABLE+VARIABLE_BLOCK+STREAM);
    desc->blocksize = ENET_MAX_PACKET;

    EnetReceiveMask = req->receivermask;

    /* Initialize the interface */
    return( EnetPowerup() );
  }
    
SystemCode EnetPowerup()

  /*  Powerup and initialize the Ethernet Interface Board.
   * Done when a new device instance of the ethernet is created.
   */
  {
    extern int Asm_EnetInterrupt();
    register int (**intvec)() = (int(**)()) ENET_INT_LEVEL;
    register int count;
    
    /* Plug interrupt location */
    *intvec = Asm_EnetInterrupt;

    /* Clear all interrupts, flush all buffers */
    *(short *)MECSR = RESET;

    /*
     * Read Ethernet address of this host from the On-board PROM
     * and put it in the Address RAM.  Flick the AMSW bit in
     * MECSR to give the controller its address
     */

    GetLogicalHost(); /* Set network address as a side-effect */

    *(short *)MECSR = AMSW;	/* Give the ME its address */

    /*
     * Establish the ME receive criteria, and hand it both 
     * receiver buffers
     */

    *(short *)MECSR |= (RXMODE | ABSW | BBSW);

    /* enable rcv interrrupts */
    *(short *)MECSR |= (RXMODE | AINTEN | BINTEN);

/*    if( EnetReceiveMask & ENET_BROADCAST ) receive broadcast;

    if( EnetReceiveMask & ENET_SELF ) receive to self;
*/
    return( OK );
 }

SystemCode EnetRelease( req, desc )
    IoRequest *req;
    DeviceInstance *desc;
   /*
    * Release the ethernet instance.
    */
  {
    desc->owner = 0; /* Free the descriptor */
    /* It is assumed that the reader will unblock on next packet
     * if currently blocked.
     */
    return( OK );
  }

SystemCode EnetRead( req, desc ) IoRequest *req; DeviceInstance *desc;

   /* Handle a read instance request for the Ethernet interface.
    */
  {
    extern Process *Active;
    SystemCode	r;

    /*
     * Reply for RETRY if already a waiting reader process.
     * This effectively provides busy-wait queuing for reading.
     */
    if( ValidPid(desc->reader) ) return( RETRY );

    if( (r=EnetCheckRequest(req)) != OK ) return( r );

    /* Check if packet waiting in network interface.
     */

    if( EnetReadPacket(req, desc, Active) == OK ) return( OK );

    /* Wait for a packet to arrive */
    desc->reader = Active->pid;
    Active->state = AWAITING_INT;

    return( NO_REPLY );
  }

SystemCode EnetWrite( req, desc ) IoRequest *req; DeviceInstance *desc;

   /* Handle a write instance request to the Ethernet interface.
    */
  {
    extern	ProcessId EnetWriter;
    extern	Process *Active;
    IoReply	*reply = (IoReply *) req;
    SystemCode r;
    register int words;
    register short	*p, *enetptr;
    register	unsigned bytes;
    register char *buffer;

    if( (r = EnetCheckRequest(req)) != OK ) return( r );

    /*
     * Reply for RETRY if currently writing.
     * This effectively provides busy-wait queuing for writing.
     */
    if( EnetWriter ) return( RETRY );

    buffer = req->bufferptr;

    EnetWriter = Active->pid;
  
    /* Transfer a packet to the Ethernet Interface Board. */

    bytes = bytes + ( bytes & 1 ); /* make it even */

    p = (short *) buffer;
    enetptr = (short *)(SENDEND - bytes);

    words = bytes >> 1;	/* length in words */

    /* Write packet to interface */
    ++words;
    while( --words ) *enetptr++ = *p++;

    enetptr = (short *)(SENDEND - bytes);

    *(short *)METXHDR = (short)((unsigned)enetptr - (unsigned)METXHDR);
    EnetCollisions = 0;    
    *(short *)(MECSR) |= (RXMODE | TBSW | TINTEN | JINTEN);

    /* Dont wait for the interrupt. No point */

    return( OK );
  }

SystemCode EnetQuery( req, desc ) QueryEnetReply *req; DeviceInstance *desc;

  {
    req->EthernetHostNumber = EnetHostNumber;
    req->NumCollisions = EnetCollisions;
    req->NumOverflows = EnetOverflows;
    req->NumCRCErrors = EnetCRCerrors;
    req->NumSyncErrors = EnetSyncErrors;
    req->NumTimeOuts = EnetTimeouts;
    req->NumValidPackets = EnetValidPackets;

    return( OK );
  } 


SystemCode EnetCheckRequest( req ) register IoRequest *req;

  /* Check that the read or write request is has a legitmate buffer, etc.
   */
  {
    register unsigned count;
    register SystemCode r;

    /*  Check length */
    count = req->bytecount;

    req->bytecount = 0; /* To be left zero if a check fails */
    if( count > ENET_MAX_PACKET ||  (count <= IO_MSG_BUFFER) )
	r = BAD_BYTE_COUNT;
    else  /* Make sure data pointer is valid.
	   *  Check that on a word boundary and not in the kernel area.
	   */
    if( (BadUserPtr(req->bufferptr)) ||
    (Active->team->team_space.size < (req->bufferptr + count)) ||
    ((int) req->bufferptr) & 1 )
	r = BAD_BUFFER;
    else
      {
	req->bytecount = count;
	r = OK;
      }
    return( r );
  }

EnetInterrupt()

   /* Handle an interrupt from the ethernet interface.
    */
  {
    extern DeviceInstance *EthernetInstance;
    extern ProcessId EnetWriter;
    extern Process *Moveq_head, *Moveq_tail;
    register Process *pd;
    register IoRequest *req;
    register IoReply *reply;
    register DeviceInstance *desc;
 
    desc = EthernetInstance;

    if( (*(short *)MECSR & (ABSW|BBSW)) != (ABSW|BBSW) )
      {  /* Receiver interrupt */
	if( desc )
	  {
	    if( (pd = Map_pid(desc->reader)) == NULL )
	      {
		if( Map_pid(desc->owner) == NULL )
		  {
		    desc->owner = 0; /* Free the descriptor */
		    EthernetInstance = NULL;
		  }
	    	else
		  {
		  }
		desc = NULL; 
	      }
	    else req = (IoRequest *) pd->msg;
	  }
	if( EnetReadPacket(req, desc, pd) == OK )
	  {
	    reply = (IoReply *) req;
	    reply->replycode = OK;
	    desc->reader = 0;
	    Addready( pd );
	  }
      }
    else if( EnetWriter )
      {  /* Transmitter interrupt */
	if( *(short *)(MECSR) & JAM ) { TryEnetTransmit(); return; }
	if( (*(short *)MECSR & TBSW) != 0 ) return;

	EnetWriter = 0; /* No transmission in progress now */
	* (short *)MECSR &= (~TINTEN);

	/* Remote block transmission */
	if( Moveq_head != NULL )
	  {
	    register Process *pd = Moveq_head;
	    unsigned help, noPackets;
	    noPackets=
(pd->remoteSegmentSize-1-MAX_APPENDED_SEGMENT*pd->moveIndex)/MAX_APPENDED_SEGMENT + 1;
	    if( noPackets == 1 )
	      {
		help = pd->remoteSegmentSize % MAX_APPENDED_SEGMENT;
		if( help == 0 ) help = MAX_APPENDED_SEGMENT;
		WriteKernelPacket(remoteMoveToReq,pd->pid,pd->blocked_on,
				  0,help, pd->remoteSegmentSize,
		(unsigned)pd->remoteSegmentPtr+pd->moveIndex*MAX_APPENDED_SEGMENT,
		pd->seqNo,NULL,
		(unsigned)pd->dataSegmentPtr+pd->moveIndex*MAX_APPENDED_SEGMENT);
		if( (Moveq_head=pd->link) == NULL )
		    Moveq_tail = (Process *) &Moveq_head;
	      }
	    else
	      {
		WriteKernelPacket(remoteMoveToReq,pd->pid,pd->blocked_on,
		0,MAX_APPENDED_SEGMENT,pd->remoteSegmentSize,
		(unsigned)pd->remoteSegmentPtr+pd->moveIndex*MAX_APPENDED_SEGMENT,
		pd->seqNo,NULL,
		(unsigned)pd->dataSegmentPtr+pd->moveIndex*MAX_APPENDED_SEGMENT);
		pd->moveIndex++;
	      }
 	   }
      }
  }

SystemCode EnetReadPacket( req, desc, pd )
  register IoRequest *req;
  DeviceInstance *desc;
  Process *pd;
   /*  Physically transfer a packet from the Ethernet
    *  Interface Board into the reading process's buffer.
    *
    */
  {
    extern Process *Active;
    extern PFPID RemoteTrapTable[];
    register unsigned	words, readwords, bytes;
    register short	*p;
    short		status;
    IoReply		*replymsg = ( IoReply * ) req;
    short		*save, *foo, *mehdr, mecsr;
    SystemCode		ret;

    /* Find a valid error-free packet */
    while(1)
      {
	switch( (*(short *)MECSR & (ABSW | BBSW)) >> 14 )
	  {
        case 0:	/* Both have a packet, take the first one received */
		if(*(short *)MECSR & RBBA)
		    goto ReadB;
		else
		    goto ReadA;

	case 1:	/* Receive buffer B has packet */
	ReadB:
		mehdr = (short *) MEBHDR;
		mecsr = BBSW;
		break;
	case 2: /* Receive buffer A has packet */
	ReadA:
		mehdr = (short *) MEAHDR;
		mecsr = ABSW;
		break;
	case 3: /* Both are empty */
		return ( END_OF_FILE );
      }
	bytes = (*mehdr & 0x7FF) - 2;
	words = (bytes+1) >> 1;

	if( (*mehdr & (FCSerr|FRAMerr|RANGerr)) == 0 )
	  {
	    /* A valid packet */

	    /* Get the first two words of the packet and figure out
	       if it is a kernel packet */
	    EnetPacket = (EnetBlock *) (mehdr + 1);
	    kPacketSave = (kPacket *) EnetPacket->data;
	    if( EnetPacket->EtherType != KERNEL_PACKET ||
		(kPacketSave->dstPid & REMOTE_ALIAS_PROCESS) )
	      {
		/* First case: it is not a kernel packet */
		/* and not to a remote alias process */

		if( req == NULL ) /* No reader process */
		  {
		    if( desc == NULL )  /* Ethernet device not open */
		      {  /* Discard packet */
			ret = NO_REPLY;
			goto finishpacket;
		      }
		    /* Disable receiver interrupts on this buffer */
		    *(short *) MECSR &= ~(mecsr==ABSW ? AINTEN : BINTEN);
		    NetAlarm = ENET_READER_TIMEOUT;
		    return( NO_REPLY );
		  }
		/* First, fill in the bytecount in the reply */
	    	if ( ( words << 1 ) < req->bytecount )
		  req->bytecount = words << 1;
	    	/* Now decide where to put the data */
		SetProcessContext( pd );
	    	if( req->bytecount <= IO_MSG_BUFFER ) 
		  p = (short *) req->shortbuffer;
	    	else
		  p = (short *) req->bufferptr;

		foo = ( short * ) EnetPacket;
		/* Copy data to correct location */
	    	readwords = (req->bytecount >> 1) + (req->bytecount & 1);
	    	if( words <= readwords )
	      	  {
		    ++words;
		    while( --words ) *p++ = *foo++;
	      	  }
	    	else /* A larger packet than requested */
	      	  {
		    words -= readwords;
		    ++readwords;
		    while( --readwords ) *p++ = *foo++;
		    ++words;
	      	  }
		ret = OK;
		SetProcessContext( Active );
	      }
	    else
	      {
		/* Second case : a kernel packet */
		/*
		 * Note that this only reads the control portion of the packet.
		 * The data portion, if there, is read by ReadDataPacket().
		 */
		(*RemoteTrapTable[(kPacketSave->packetType)&0xf])();
		ret = NO_REPLY;
	      }
finishpacket:
	    /* Return packet to receiver */
	    
	    *(short *) MECSR |= mecsr;
	    ++EnetValidPackets;
	    return( ret );
	  }
	/* Otherwise we discard this packet */

	if( *mehdr & (FCSerr|FRAMerr) ) ++EnetCRCerrors;
	if( (words > (ENET_MAX_PACKET>>1)) || (words <= 30) ||
		*mehdr & RANGerr )
	  {
	    ++EnetBadCounts;
	    ret = DEVICE_ERROR;
	  }
	*(short *) MECSR |= mecsr;
      }
/*    return( END_OF_FILE ); */
  }


/* Routines specific to the distributed version */


extern int WriteKernelPacket(type, srcPid, dstPid, forwarder, length, localaddress,
				remoteaddress,sequenceNo, msg, data )	

/* Writes kernel packet to the Ethernet */

  short		type;
  ProcessId	srcPid, dstPid, forwarder;
  unsigned	length;
  Unspec	*localaddress;
  Unspec	*remoteaddress;
  unsigned short	sequenceNo;
  long		*msg;
  unsigned char *data;
  {
    extern ProcessId EnetWriter;
    EnetBlock *enetpacket;
    register kPacket *packet;
    register short *ptr;
    register long *lptr;
    register short lwords;
    register short buffer, *shortdata;
    short words;

    EnetCollisions = 0;
    if( EnetWriter )
      {
        /* Wait for the interface, handling retransmission */
	while (*(short *)(MECSR) & TBSW)
	  TryEnetTransmit();
      }
    EnetWriter = 1;
    words = 0;
    if( data != NULL ) words = (short)((length>>1) + (length&1));
    enetpacket = (EnetBlock *) (SENDEND - (sizeof(kPacket)+14 + (words<<1)));
    enetpacket->DestHost = HostAddress[dstPid>>24];
    enetpacket->SrcHost = EnetHostNumber;
    enetpacket->EtherType = KERNEL_PACKET;
    packet = (kPacket *) enetpacket->data;
    packet->packetType = type;
    packet->sequenceNo = sequenceNo;
    packet->srcPid = srcPid;
    packet->dstPid = dstPid;
    packet->forwarder = forwarder;
    packet->userNumber = 0;		/* user number */
    packet->length = length;
    packet->localaddress = localaddress;
    packet->remoteaddress = remoteaddress;
    if( msg != NULL )
      {
	lptr = (long *) &(packet->msg[0]);
	*lptr++ = *msg++;
	*lptr++ = *msg++;
	*lptr++ = *msg++;
	*lptr++ = *msg++;
	*lptr++ = *msg++;
	*lptr++ = *msg++;
	*lptr++ = *msg++;
	*lptr = *msg;
      }
    if( data == NULL ) goto transmit;

/* Think this is a goof too
    ptr = (short *) &(((kPacketWithSegment *)packet)->data[8]);	*/
    ptr = (short *) &(((kPacketWithSegment *)packet)->data[0]);
    lwords = words>>1;
    ++lwords;
    if( ((unsigned) data & 1) == 0 )
      {
	shortdata = (short *) data;
	while( --lwords ) { *ptr++ = *shortdata++; *ptr++ = *shortdata++; }
      }
    else
      {
	while( --lwords )
	  {
	    buffer = *data++;
	    *ptr++ = buffer<<8 | *data++;
	    buffer = *data++;
	    *ptr++ = buffer<<8 | *data++;
	  }
      }
transmit:	
    *(short *)METXHDR = (short)((unsigned)enetpacket - (unsigned)METXHDR);
    
    *(short *)(MECSR) |= (RXMODE | TBSW | TINTEN | JINTEN);

    return(OK);
  }

int ReadDataPacket ( bytes, dst )
register unsigned bytes; register unsigned char *dst;

  {
    register int words, lwords;
    register short *ptr, *shortdst, buffer;

    words = ( bytes >> 1 ) + ( bytes & 1 );
    lwords = words >> 1;
    ++lwords;
    ptr = (short *) &(kPacketSave->msg[8]);
    if( ((unsigned) dst & 1) == 0 )
      {
	shortdst = (short *) dst;
	while( --lwords ) {*shortdst++ = *ptr++; *shortdst++ = *ptr++; }
	if( words & 1 ) *shortdst++ = *ptr++;
      }
    else
      {
	while( --lwords )
	  {
	    buffer = *ptr++;
	    *dst++ = (unsigned char) (buffer>>8);
	    *dst++ = (unsigned char) (buffer);
	    buffer = *ptr++;
	    *dst++ = (unsigned char) (buffer>>8);
	    *dst++ = (unsigned char) (buffer);
	  }
	if( words & 1 )
	  {
	    buffer = *ptr++;
	    *dst++ = (unsigned char) (buffer>>8);
	    *dst++ = (unsigned char) (buffer);
	  }
      }
    if( bytes & 1 )
      {
	if( ((unsigned)dst & 1) != 0 )
	    *dst = (unsigned char) (*ptr>>8);
	else
	  {
	    dst = (unsigned char *) shortdst;
	    *dst = (unsigned char) (*ptr>>8);
	  }
       }
    return( OK );
  }

int DiscardDataPacket ( bytes ) unsigned bytes;

  {
    return( OK );
  }

TryEnetTransmit()
{
if( *(short *)(MECSR) & JAM )
  {
    if (++EnetCollisions > 10)
      {
	*(short *)(MECSR) = RESET;
	*(short *)(MECSR) = (RXMODE|ABSW|BBSW|AINTEN|BINTEN);
	++EnetTimeouts;
	EnetWriter = 0;
      }
    else
      {
	unsigned short delay;

        /* C library routine rand() */

	delay = rand();
	delay = ((delay<<(16-EnetCollisions))>>16-EnetCollisions);
        *(short *)(MEBACK) = delay;
        *(short *)(MECSR) |= (RXMODE | JAM | TINTEN | JINTEN);
      }
  }
}

int NetCheck()
  {
    extern Process *Pd_bundle[];

    if( EthernetInstance == NULL )
      {
	/* Read packet out of interface and re-enable receiver interrupt */
	EnetReadPacket( NULL, NULL, NULL );
	/***	?  What is this ***/
	return;
      }
    if( Map_pid( EthernetInstance->reader ) != NULL )
      {
	/* Reader is present: return immediately */
	return;
      }
    if( Map_pid( EthernetInstance->owner ) == NULL )
      {
	/* The owner has gone away: free the descriptor, read out of
	   interface and re-enable the receiver interrupt */
	EthernetInstance->owner = NULL;
	EthernetInstance = NULL;
	EnetReadPacket( NULL, NULL, NULL );
	/*** What is this ? 
	EnetStatus &= ~EnetRxIntDisable; ***/
	return;
      }
    /* The owner is still there, reader not present: read out of interface
       and reset the alarm clock */
    EnetReadPacket( NULL, NULL, NULL );
    NetAlarm = ENET_READER_TIMEOUT;
  }	  
