/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 * (Transliterated from Zed and Verex Kernel)
 *
 * Configuration Parameters for the Kernel.
 */

#ifndef CONFIG
#define CONFIG

#include "../../libc/include/Venviron.h"

#define MAX_PROCESSES 64	/* Maximum number of processes; this currently
				 * required to be a power of two */
#define MAX_TEAMS 16		/* Maximum number of teams */
#define MAX_LOGICAL_ID	40	/* Maximum logical id for GetPid and SetPid */
#define MAX_DEV_CODE 10		/* Maximum number of device codes */
#define ROOT_PRIORITY 4		/* Priority of first created process */
#define INIT_STACK 4000		/* Size of initial stack for root team */

/*
 * Kernel device configuration declarations.
 */

#define MAX_DEVICES	16		/* Must be a power of 2 */
#define MAX_DEV_TYPE	5

typedef struct _DC
  {
    SystemCode		(*CreateFunc)();
    short unsigned	type;
  }
    DeviceConfigTable;

/* Nonlocal Operations "macroed" out in local kernel configuration */

#define NonlocalSend(msg, pid) 0
#define NonlocalReceive( msg ) 0
#define NonlocalReply( msg, pid ) 0
#define NonlocalReceiveSpecific( msg, pid ) 0
#define NonlocalReply( msg, pid ) 0
#define NonlocalForward1( msg, from_pid, to_pid ) 0
#define NonlocalForward2( msg, from_pid, to_pid ) 0
#define NonlocalAwaitingReply( pid1, pid2 ) 0
#define NonlocalRewriteMsg( msg, pid ) 0
#define NonlocalRereadMsg( msg, pid ) 0
#define NonlocalMoveto( dest_pid, dest, src, bytes ) 0
#define NonlocalMovefrom( src__pid, src, dest, bytes ) 0

#endif
