/*
 * pup/telnet.c - PUP user telnet under Vkernel with VGTS
 *
 * by Bill Nowicki
 *  September 1982
 *
 * Merged with stand-alone stuff April 1983 WIN
 *
 * Internet server interface added WIN & MMT August 1983
 */

# include <Venviron.h>
# include <Vioprotocol.h>
# define  ENET3MEG
# include <Vethernet.h>
# include <m68enet.h>
# include <Vnet.h>
# include <Vgts.h>
# include <Vteams.h>
# include <chars.h>

# define VkernelEthernet 1000
# undef ETHERNET			/* puplib.h redefines it!! */

# include "state.h"			/* for PUP telnet use only */

# define EthernetOffset ENPACKOVER+2	/* packet buffer offset */
# define PupOverhead    PUPACKOVER	/* bytes */
	
/*
 * User-defined message types for internal use.
 */
enum MessageKind { Keyboard, Timer, NetIn, NetOut };

# define BigStack 2800		/* 3000 works */
# define SmallStack 500		/* 500 works */
# define MaxVGTs 4		/* number of displays for now */

extern RootMessage *RootMsg;	/* tn's root message */

short Debug = 0;
short InputPad = 0;		/* pad for current input */
short RawNet = FALSE;		/* true if using Raw Network */

static Process_id Mut, TimerId, KeyboardId, NetInId, NetOutId,
	KbHelperPid;
	
Process_id VgtsPid;

static File 	*EnetOutFile, *EnetInFile;
				/* Ethernet files */

int	MaxSize; 		/* Maximum chars in a packet */

unsigned char ThisHost;		/* This host number */

static File *FileTable[MaxVGTs+1][2];	/* table of file Descriptors */
static Process_id ReaderTable[MaxVGTs+1];

static int MutProcess();
static int ShoveHost();
static int KeyboardProcess();
static int NetOutProcess();
static int NetInProcess();
static int TimerProcess();

main(argc, argv)
    int argc;
    char **argv;
{
    Message msg;
    int i;
    int forceRaw = 0;

    for (i=1; i<MaxVGTs; i++)
      {
        FileTable[i][0] = NULL;
        FileTable[i][1] = NULL;
      }
# ifdef STANDALONE
    Initialize();
# else
    FileTable[0][0] = stdin;
    FileTable[0][1] = stdout;
    ModifyPad(stdout,ReportEscSeq);
    if (argc > 1 && strcmp( argv[1], "raw")==0)
      {
        forceRaw = 1;
	argc--;
	argv++;
      }
# endif STANDALONE

    Mut        = GetPid(ACTIVE_PROCESS,LOCAL_PID);
    NetInId    = Create(8, NetInProcess, SmallStack);
    NetOutId   = Create(11, NetOutProcess, SmallStack);
    TimerId    = Create(99, TimerProcess, SmallStack);
    KeyboardId = Create(99, KeyboardProcess, SmallStack);

    InitPupConnection(forceRaw);
    ModifyPad(stdout,ReportEscSeq);
    Reply( msg, TimerId);
    Reply( msg, NetInId);
    Reply( msg, NetOutId);
    Ready( KeyboardId, 2, FileTable[0][0], 0);
# ifdef STANDALONE
    KeyboardId = Create(99, KeyboardProcess, SmallStack);
    Ready( KeyboardId, 2, FileTable[1][0], 1);
    KeyboardId = Create(99, KeyboardProcess, SmallStack);
    Ready( KeyboardId, 2, FileTable[2][0], 2);
    KeyboardId = Create(99, KeyboardProcess, SmallStack);
    Ready( KeyboardId, 2, FileTable[3][0], 3);
# else STANDALONE
    if (argc > 1) 
        {
	  KeyboardId = Create(99, ShoveHost, SmallStack);
          Ready( KeyboardId, 1, argv[1]);
	}
# endif STANDALONE
    MutProcess();
}


# ifdef STANDALONE

# include <confreg.h>

/*
 * this code is used only in the Stand-alone (non exec) version of the world.
 */

extern short TtySDF, TtyVGT, Unique;

VgtsProcess()
  {
    Message msg;
    short vgt;
    short Config;		/* configuration register */

    Config = emt_getconfig();
    SetTime(GetRemoteTime(), 0);
    if (( (struct ConfReg *)&Config )->FBType )
      {
      	/*
	 * Landscape format screen (wide)
	 */
	InitVgts( 690, 688, 1050, 790);
	vgt = PadInit( TtySDF, Unique++, "PUP Telnet 1", 
    		PadHeight, PadWidth );
	InputPad = vgt;
        CreateView( vgt, 6, 318, 
		6+ViewWidth(PadWidth), 318+ViewHeight(PadHeight), 0, 0, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "PUP Telnet 2",
    		PadHeight, PadWidth );
        CreateView( vgt, 116, 212, 
	      116+ViewWidth(PadWidth), 212+ViewHeight(PadHeight), 0, 0, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "PUP Telnet 3",
    		PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 220, 100, 
	     220+ViewWidth(PadWidth), 100+ViewHeight(PadHeight), 0, 0, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "PUP Telnet 4",
		 PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 324, 4, 
	      324+ViewWidth(PadWidth),  4+ViewHeight(PadHeight), 0, 0, 0, 0);
        MakeTopXY( 10, 350);
      }
     else
     {
	   /*
            * Portrait format screen (tall)
	    */
	InitVgts( 190, 4, 500, 90);
    	vgt = PadInit( TtySDF, Unique++, "PUP Telnet 1", 
    		PadHeight, PadWidth );
        InputPad = vgt;
        CreateView( vgt, 4, 550, 
	    4+ViewWidth(PadWidth), 550+ViewHeight(PadHeight), 0, -2, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "PUP Telnet 2",
    		PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 24, 394, 
	      24+ViewWidth(PadWidth), 394+ViewHeight(PadHeight), 0, -2, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "PUP Telnet 3",
    		PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 44, 236, 
	    44+ViewWidth(PadWidth), 236+ViewHeight(PadHeight), 0, -2, 0, 0);
        vgt = PadInit( TtySDF, Unique++, "PUP Telnet 4",
    		PadHeight, PadWidth );
        if (vgt>0)
	  CreateView( vgt, 84, 40, 
	    84+ViewWidth(PadWidth), 40+ViewHeight(PadHeight), 0, -2, 0, 0);
        MakeTopXY( 20, 990);
     }

    TtyMessage( "SUN Virtual Graphics Terminal Service" );
    TtyMessage( "With PUP User Telnet" );
    while (1) GetMessage(0,0,msg);
  }

Initialize()
  {
    SystemCode error;
    short i;

    if (GetPid(EXCEPTION_SERVER,LOCAL_PID)==0)
        InitExceptionServer();
    VgtsPid = Create(8,VgtsProcess, BigStack);
    Ready(VgtsPid,0,0);
    for (i=0; i<MaxVGTs; i++)
      {
        FileTable[i][0] = OpenFile( VgtsPid, i+1, FREAD, &error );
        FileTable[i][1] = OpenFile( VgtsPid, i+1, FCREATE, &error );
        ModifyPad(FileTable[i][0],ReportEscSeq);
      }
}

ExecControl()
  {
    TtyBlinkError("Execs Not implemented");
  }

# endif STANDALONE

static MutProcess()
  {
	/*
	 * The master multiplexor process for this program
	 */
    Message msg;

    PrintHelp();
    InitializeMUT( MaxVGTs );
    while (1)
      GetMutMessage(0,0,msg);
}


static GetMutMessage(mouseFlag, keyboardFlag, msg)
  int mouseFlag;	/* true if we return on mouse input */
  int keyboardFlag;	/* true if we retun on keyboard input */
  IoRequest *msg;	/* message that we return */
 {
     int i;

     while (1)
      {
        /*
         * receive a message and drive mut.
	 * return if we get the kind we are waiting for,
	 * Otherwise just handle it and repeat.
         */
        Process_id pid;

	pid = Receive( msg );
        switch (msg->requestcode)
          {
	    case Timer:
	    	ClockTick();
		Reply( msg, pid );
		break;

	    case Keyboard:
		UserString(msg->fileid,msg->bufferptr,msg->bytecount);
		Reply( msg, pid );
	    	break;
		
	    case NetIn:
		Reply( msg, pid );
	    	NetRead( msg->bufferptr );
		break;

	    case NetOut:
	    	NetDone();
		break;

            default:
                printf( "Strange message type: %d\r\n", msg->requestcode );
          }
      }
}


UserString(user,pointer,count)
    short user;
    register char *pointer;
    int count;
  {
    if (count<=0) return;
    while (count-->1)
      UserPutChar(user,*pointer++);
    UserRead(user,*pointer); 
  }


static PrintHelp()
  {
# ifndef STANDALONE
    printf("Commands are control up-arrow followed by:\r\n");
    printf("  c to close a connection, e to exit\r\n");
    printf("  o to open another VGT, b for a big VGT");
 /* printf("  1, 2, 3, 4, etc to select\r\n"); */
# endif STANDALONE
  }


static NetInProcess()
  {
	/*
	 * read packets from the Network and send them to Mut .
	 * Double buffer because we pass a pointer in the message.
	 */
    IoRequest msg;
    static EnetBlock buf1, buf2;
    int rv;

    while (1)
      {
	 while ((rv = Read( EnetInFile, &buf1, ENET_MAX_PACKET)) <= 0)
	    printf( "Network Read error %d\r\n", rv);
	 msg.requestcode = (SystemCode)NetIn;
	 if (RawNet)
	   {
	     msg.bufferptr = (char *)(buf1.data);
	     if (buf1.EtherType != PUP)    continue;
	   }
	 else msg.bufferptr = (char *)(&buf1);
	 Send( &msg, Mut);
	 if (RawNet)
	  do
	   {
 	     while ((rv = Read( EnetInFile, &buf2, ENET_MAX_PACKET)) <= 0)
	        printf( "Ethernet Read error %d\r\n", rv);
	     msg.requestcode = (int)NetIn;
	     msg.bufferptr = (char *)(buf2.data);
	     if (buf2.EtherType != PUP)    continue;
	     Send( &msg, Mut);
	   } while (buf2.EtherType != PUP);
	else
	  {
	     while ((rv = Read( EnetInFile, &buf2, ENET_MAX_PACKET)) <= 0)
	        printf( "Ethernet Read error %d\r\n", rv);
	    msg.requestcode = (int)NetIn;
	    msg.bufferptr = (char *)(&buf2);
	    Send( &msg, Mut);
	  }
      }
  }



static NetOutProcess()
  {
	/*
	 * Send packets over Ethernet.  
	 * Packet buffers come back from MUT as replies.
	 * msg.fileid has immediate Ethernet host,
	 * msg.bufferptr has a pointer to the PUP buffer.
	 */
    ProcessId pid;
    short checkLength, length;
    IoRequest msg;
    struct PupPacket *pup;
    static EnetBlock buf;

    while (1)
      {
	msg.requestcode = (SystemCode)NetOut;
	msg.bufferptr = NULL;
	pid = Send( &msg, Mut);
	if (pid==0) while (1) Receive(&msg);
	pup = (struct PupPacket *)msg.bufferptr;
	if ( (int)(msg.bufferptr) & 1)
	  {
	    printf("Odd address 0x%x in Net Out! pid=%x\r\n", msg.bufferptr, pid);
	    continue;
	  }
	length  = roundup(pup->PupLength);
	checkLength = (length - PUPACKOVER )>>1;
	( (short *) (pup->PupData) )[checkLength] = checksum( pup, length-2 );
	if (RawNet)
	  {
	    bmove( pup, buf.data, length );
	    buf.SrcHost = ThisHost;
	    buf.DestHost = msg.fileid;
	    buf.EtherType = PUP;
	    if (Write( EnetOutFile, &buf, length + 4) != length+4)
	      printf("Enet Write Error\r\n");
	  }
 	else
	  {
	    if (Write( EnetOutFile, pup, length) != length)
	        printf("Enet Write Error\r\n");
	  }
      }
  }


GetHost()
  {
    return(ThisHost);
  }

GetNet()
  {
  	/*
	 * Return the PUP network number.
	 * I'm tired of these routing errors!
	 * Wait a while if we don't know our network number.
	 */
    extern unsigned char OurNetNumber;
    
    if (OurNetNumber==0) 
      {
	Delay(0,10);
      }
    return( OurNetNumber );
  }


NetWrite( pkt, dest)
 char *pkt;
  {
	/*
	 * MUT wants to send a packet to the given immediate destination.
	 * pkt is a pointer to the PUP part of the packet
	 */
    IoRequest msg;
    Process_id pid;

    msg.requestcode = OK;    
    msg.bufferptr = pkt;
    msg.fileid = dest;
    pid = Reply( &msg, NetOutId );
    if (pid==0) 
     {
        /* DO SOMETHING!!!! */
     }
  }



InitPupConnection(forceRaw)
  {
  	/*
	 * initialize a PUP connection with the internet server,
	 * or the Ethernet device if we can't load the server.
	 */
  SystemCode error;
  Message m;
  register CreateInstanceRequest *msg = (CreateInstanceRequest *) m;
  ProcessId netPid;
  PupParms *ct;
  File *_Open();
  static char *argv[] = { "internetserver", NULL};

  ThisHost = EIAddress;

# ifndef STANDALONE

	/*
	 * Please note that we must do TWO GetPids.
	 * The first determines if there is an internet server
	 * anywhere on the network; if not then we load one.
	 * The second GetPid below tells us if the internet server
	 * is local.; if not then just use raw Ethernet anyway.
	 */

  netPid = forceRaw ? 0 : GetPid(INTERNET_SERVER, ANY_PID);

  if (forceRaw==0 && (netPid==0 || ValidPid(netPid)==0))
    {
        printf("Loading internet server.\r\n");
        netPid = ExecProg(argv, 1, 0, RootMsg, RootMsg, &error);
	if (netPid == NULL)
	  {
	    printf("Couldn't create an internetserver: %s.\r\n", 
	    	    ErrorString(error));
	  }
	else Delay(1,0);	/* Give the internet server a chance to
				   initialize itself before sending it a
				   request. */
      }

	/*
	 * We now do a LOCAL GetPid, to see if the network server
	 * we found was on our machine.  If it is not, then
	 * we should go ahead and use the raw device, since 
	 * iptn can use the remote internet server.
	 */
  netPid = forceRaw ? 0 : GetPid(INTERNET_SERVER, LOCAL_PID);

  if (netPid && ValidPid(netPid))
    {
      RawNet = FALSE;
      msg->requestcode = CREATE_INSTANCE;
      msg->filenameindex = 0;
      msg->filename = "Pup";
      msg->filenamelen = strlen(msg->filename);
      msg->type = PUPtype;
      ct = (PupParms *) (msg->unspecified);
      ct->socket = 0;
      EnetOutFile = _Open(msg, FCREATE|FRELEASE_ON_CLOSE, netPid, &error);
      if ((EnetOutFile) && (error == OK))
       {
         EnetInFile = OpenFile(EnetOutFile->fileserver, 
	 	EnetOutFile->fileid + 1,
  	    	FREAD|FRELEASE_ON_CLOSE, &error);
         if ((EnetInFile) && (error == OK)) 
	     return;
		/*
		 * Really strange: we could open one side but not the other
		 * of the PUP connection; close the one we did open.
		 * Normal closes are done in exit() otherwise.
		 */
	 Close(EnetOutFile);
	}
        if (error == BUSY)
         {
           printf("You can only run one copy of tn at a time.\r\n");
	   printf("Use CTRL-SHIFT-^-o to get another tn window.\n");
	 }
       else
         printf("Error on Internetserver open: %s\r\n", ErrorString(error) );
     }


  printf("Using raw Ethernet device\r\n");

# endif STANDALONE

  RawNet = TRUE;
  msg->requestcode = CREATE_INSTANCE;
  msg->type = VkernelEthernet;
  msg->filemode = FCREATE + FBLOCK_MODE;
  msg->filenameindex = 0;
  ((CreateEnetRequest *)msg)->receivermask = ENET_DEFAULT_MASK;
  msg->filename = "Ethernet";
  msg->filenamelen = 9;

  EnetOutFile = _Open(msg, FCREATE + FBLOCK_MODE, 
  	GetPid(DEVICE_SERVER,LOCAL_PID), &error);
  if (error || (EnetOutFile == NULL))
    {
      printf("Error on Ethernet open: %s\r\n", ErrorString(error) );
      exit(1);
    }
  EnetInFile = OpenFile(EnetOutFile->fileserver, EnetOutFile->fileid,
  	    	FREAD|FRELEASE_ON_CLOSE, &error);
  if (error || (EnetInFile == NULL))
    {
      if (error == BUSY)
         {
           printf("You can only run one copy of tn at a time.\r\n");
	   printf("Use CTRL-SHIFT-^-o to get another tn window.\n");
	 }
      else
        printf("Error on Ethernet open: %s\r\n", ErrorString(error) );
      exit(1);
    }
 }   /*  InitPupConnection */


NetReset()
  {
  	/*
	 * Null routine for MUT's sake
	 */
  }


static ShoveHost(name)
  char *name;
  {
	/*
	 * shove the argument in as if the user typed a host name
	 */
    IoRequest msg;

   msg.requestcode = (int)Keyboard;
   msg.bufferptr = name;
   msg.bytecount = strlen(name);
   msg.fileid = 0;
   Send( &msg, Mut);
   msg.bufferptr = "\n";
   msg.bytecount = 1;
   Send( &msg, Mut);
   DestroyProcess(0);
  }

static KeyboardProcess(f,user)
  File *f;
  {
	/*
	 * read chars from one pad and send them to MUT.
	 */
    IoRequest msg;
    register char c;
    int rv;
# define KeyBufSize 32
    char buf[KeyBufSize];
    int bufnum = 0;

    while (1)
      {
	 msg.requestcode = (int)Keyboard;
         msg.bufferptr = buf;
	 msg.bytecount = 0;
	 msg.fileid = user;
	 while (msg.bytecount<KeyBufSize)
	   {
	     msg.bufferptr[msg.bytecount++] = getc(f);
	     if (BufferEmpty(f)) break;
	   }
	 Send( &msg, Mut);
      }
  }


static TimerProcess()
  {
	/*
	 * Send a clock tick mesage every quarter second.
	 */
    IoRequest msg;
    while (1)
      {
         Delay( 0, 25);
         msg.requestcode = (int)Timer;
	 Send( &msg, Mut);
      }
  }

TelnetPutChar(c,user)
  {
    if (FileTable[user][1]==NULL) return;
    putc(c,FileTable[user][1]);
  }

TelnetFlush(user)
  {
    if (FileTable[user][1]==NULL) return;
    Flush(FileTable[user][1]);
  }

OpenSmall()  { OpenMUT(28,80); };
OpenBig()    { OpenMUT(48,80); };

OpenMUT(lines,columns)
  {
    /*
     * Open a new connection
     */
     
     int i;
     extern File *OpenPad();
     SystemCode error;
     register File *f;

     for (i=0;i<MaxVGTs;i++)
       if (FileTable[i][0]==NULL)
         {
	   f = OpenPad("PUP Telnet", lines, columns, &error);
	   if (f==NULL)
	     {
	       if (error != RETRY)
	         printf("Error: %s opening the pad\r\n", ErrorString(error) );
	       return;
	     }
	   ModifyPad(f,ReportEscSeq);
	   FileTable[i][1] = f;
     	   f = OpenFile( f->fileserver, f->fileid, FREAD, &error );
	   FileTable[i][0] = f;
	   SelectPad(f);
	   NewConnection(i);
    	   KeyboardId = Create(99, KeyboardProcess, SmallStack);
           Ready(KeyboardId, 2, f, i);
	   ReaderTable[i] = KeyboardId;
	   return;
	 }
    printf("No more connections allowed.\r\n");
  }

DeleteMUT(userNumber)
  {
      /*
       * Delete the VGT associated with the given user number
       */
     if (userNumber==0 || FileTable[userNumber][1]==NULL) return;
     Close( FileTable[userNumber][1] );
     FileTable[userNumber][0] = NULL;
     FileTable[userNumber][1] = NULL;
     if (ReaderTable[userNumber]) DestroyProcess(ReaderTable[userNumber]);
     ReaderTable[userNumber] = 0;
  }

MutSetBanner(userNumber,name)
    char *name;
  {
      /*
       * Set the VGT banner associated with the given user number
       */
     char buf[128];

     if (FileTable[userNumber][1]==NULL) return;
     sprintf(buf,"tn %s",name);
     SetVgtBanner(FileTable[userNumber][1],buf);
   }


ExitMUT()
  {
    /*
     * Exit the whole dang program
     */
    exit();
  }
