/*
 * Utility program to alias names.
 *
 * Add the names argv[1] to argv[argc-2] for the context
 * named by argv[argc-1].  
 * Rob Nagler 10/83
 */

#include <Venviron.h>
#include <Vio.h>
extern char *ErrorString();
extern SystemCode AliasContextName();
extern SystemCode DeleteContextName();

main( argc, argv )
    int argc;
    char **argv;
  {
    register char **NewName;
    register char *OldName;
    register int NameCount;
    register SystemCode r;
    
    if ( (NameCount = --argc) < 2 )
      {
        fprintf( stderr, "usage: %s {name} contextname", argv[0] );
	exit( BAD_ARGS );
      }

    for( OldName = argv[ NameCount-- ], NewName = &argv[ 1 ]
         ; NameCount > 0
	 ; NewName++, NameCount-- )
      {
	/* First delete the new name's old value;
         *   don't care if it doesn't exist */
	DeleteContextName( *NewName );

	/* Since this program will most often be called with
	 *   only one NewName, don't bother optimizing # of requests */
        if ( (r = AliasContextName( *NewName, OldName )) != OK )
	  {
	    fprintf( stderr, "%s %s %s: %s\n", argv[0], *NewName, OldName
	             , ErrorString( r ) );
	    exit( r );
	  }
      }

  } /* main */
        
         
    
     

    
