/*
 * Print the current working context of this program.
 * Rob Nagler 8/10/83
 *
 * TPM 8/25/83 - Takes an optional argument specifying the
 *  context to print, and outputs its "full pathname."
 */

#include <Venviron.h>
#include <Vio.h>
#include <Vnaming.h>

extern char *ErrorString(), *strncat();
extern SystemCode GetContextName();

#define NAME_BUFFER_SIZE	512
char NameBuffer[2][ NAME_BUFFER_SIZE + 1 ];

main( argc, argv )
    int argc;
    char **argv;
  {
    SystemCode error;
    ProcessId ServerPid,NewServerPid;
    ContextId Context;
    register char *NewName, *OldName, *TmpName;
    register int NameLen;
    int NewNameLen;

    if (argc > 1)
      {
	error = GetContextId(argv[1], &ServerPid, &Context);
	if (error != OK)
	  {
	    printf("%s: %s %s\n", argv[0], argv[1], ErrorString(error));
	    exit(1);
	  }
      }
    else
      {
	ServerPid = PerProcess->nameserver;
	Context = PerProcess->contextid;
      }

    NewName = NameBuffer[0];
    OldName = NameBuffer[1];
    *OldName = NULL;
    NameLen = 0;

    do 
      {
	NewServerPid = ServerPid;
	
	NewNameLen = NAME_BUFFER_SIZE - NameLen;
	
        if ( (error = GetContextName( NewName, &NewNameLen, &NewServerPid
	            		      , &Context, NewServerPid )) != OK )
          {
            /* failed to get name */
            printf( "%s: Error finding current context: %s\n", *argv
		, ErrorString( error ) );
            exit( error );
          }
	
        /* prepend the new name */
	TmpName = strncat( NewName, OldName, NameLen );
	NewName = OldName; 
	OldName = TmpName;
	
	if ( (NameLen += NewNameLen) >= NAME_BUFFER_SIZE )
	    break;
      }      
    while ( NewServerPid != ServerPid && Context != ANY_CONTEXT );

    NewNameLen = NAME_BUFFER_SIZE;

    if ( (error = GetContextName( NewName, &NewNameLen, &NewServerPid
 	, &Context, GetPid( NAME_SERVER, LOCAL_PID ) )) != OK )
      {
        /* failed to get name */
        printf( "%s: Error finding local name of context: %s\n", *argv
		, ErrorString( error ) );
        exit( error );
      }

    fputs( NewName, stdout );
    
    puts( OldName );
    
    if ( NameLen >= NAME_BUFFER_SIZE || NewNameLen >= NAME_BUFFER_SIZE )
        printf( "%s: Name may have been truncated\n", argv[0] );

  } /* main */
