#include <Vio.h>

#define MAX_LOGICAL_PID 19

char *ServerNames[] =
  {
	"ACTIVE_PROCESS",
	"EXCEPTION_SERVER",
	"DEVICE_SERVER",
	"INTERNET_SERVER",
	"STORAGE_SERVER",
	"UNIX_SERVER",
	"TIME_SERVER",
	"PRINT_SERVER",
	"VGT_SERVER",
	"NAME_SERVER",
	"CONTEXT_SERVER",
	"TEAM_SERVER",
	"PIPE_SERVER",
	"KERNEL_PROCESS",
	"HOST_SERVER",
	"server 15",
	"server 16",
	"server 17",
	"server 18",
	"server 19"
  };


main( argc, argv )
  int argc; char **argv;

  /*
   * Print the process identifiers of processes responding to the
   * standard services available thru GetPid.
   */
  {
    ProcessId pids[MAX_LOGICAL_PID];
    unsigned scope, logicalpid;

    if( argc > 2 )
      {
error:	printf( "Use: queryservers [scope]\n" );
	exit( 1 );
      }
    scope = ANY_PID;
    if( argc == 2 )
      {
	if( Equal(argv[1], "local") ) scope = LOCAL_PID;
	else
           if( Equal(argv[1],"remote") ) scope = REMOTE_PID;
	else
	   if( Equal(argv[1], "any") ) scope = LOCAL_PID;
	else
	  {
	    printf("Bad scope: %s\n", argv[1] );
	    goto error;
	  }
      }

    /* Now find the servers */
    for( logicalpid = 1; logicalpid <= MAX_LOGICAL_PID; ++logicalpid )
      {
        pids[logicalpid] = GetPid( logicalpid, scope );
	printf( "%s = %8x\n", ServerNames[logicalpid], pids[logicalpid] );
      }
  }
