/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Program to list the entries in a context directory.
 *
 * Marvin Theimer and Tim Mann, 8/83
 *
 * RJN -- 9/7/83
 *	- Added GetDescriptor and improved the output format
 *	- Also got the UnixFileDescriptor stuff working
 *
 * Bill Nowicki September 1983
 *	- Added VGTS support
 *
 * RJN -- 9/14/83
 *	- split "listdir" into "listdir" and "listdesc"
 *	- improved error handling
 */


#include <Vioprotocol.h>
#include <Vnaming.h>
#include <Vdirectory.h>

extern int ReadAndPrintDirectory();
extern ProcessId DirectToCurrentContext();

extern CompareDescriptors();

static char *myName;

main(argc, argv)
    int argc;
    char **argv;
  {
    SystemCode Error;
    int bannertype;
    register int num;

    /*
     * Process command arguments.
     */

    myName = argv[0];
    argc--;
    argv++;
    if (argc == 0)
	argv[0] = "";
	
    do
      {
        bannertype = EMPTY_DESCRIPTOR;	
	printf( "\n%s:", *argv );	
        if ( (num = ReadAndPrintDirectory( *argv, &Error, &bannertype )) == -1 ) 
	    printf( " error opening: %s\n", ErrorString( Error ) );
        if ( num == 0 )
	    printf( " is empty\n" );
	++argv;	
      }
    while ( --argc > 0 );

  } /* main */

int ReadAndPrintDirectory( dirName, error, bannertype )
    char *dirName;
    SystemCode *error;
    int *bannertype;
/*
 * Read the contents of the directory and put all non EmptyDescriptors
 * in the DescriptorList.
 * returns the number of entries or -1 if an error in opening and
 * -2 on a read error.
 */
  {
    register int i = 0;
    ArbitraryDescriptor desc;
    register File *serverFile;
    ProcessId serverPid;
    int hexpid = 0;
    
    /* Is the argument a string designating a
       server or is it a hex process id? */
    if (dirName[0] == '0' && dirName[1] == 'x')
      {
	hexpid = 1;  /* Hex pid given */
	serverPid = 0;
        dirName += 2;
        sscanf(dirName, "%x", &serverPid);
      }

    /*
     * Interact with the server.
     */

    if (hexpid)
      {
	/* Ugly code required to send to a hex pid */
	CreateInstanceRequest request;

	request.requestcode = CREATE_INSTANCE;
	request.filename = "";
	request.filenamelen = 0;
	request.filenameindex = 0;
	request.contextid = DEFAULT_CONTEXT;
	request.type = 0;
	serverFile = _Open(&request, FREAD|FDIRECTORY|FRELEASE_ON_CLOSE|FBLOCK_MODE,
	    serverPid, error);
      }
    else
      {
	serverFile = Open(dirName, FREAD|FDIRECTORY|FBLOCK_MODE, error);
      }
      

    if ( *error )
      {
        return( -1 );	/* error will be seen by caller since it is global */
      }

   
    /* load up the Descriptor list */
    do 
      {
        if ( Read( serverFile, &desc, serverFile->blocksize )
	     == serverFile->blocksize )
	  {
	    if ( desc.e.descriptortype != EMPTY_DESCRIPTOR )
	        if ( PrintDescriptor( &desc, bannertype ) )
		  {
	printf( "\nUnknown descriptor type: %d, in directory block #%d\n"
		    		, desc.e.descriptortype , serverFile->block );
		    *bannertype = EMPTY_DESCRIPTOR;
		  }
		else
		    i++;
	    serverFile->block++;
	  }
	else
	   break;	/* an error has occurred */
      }
    while ( serverFile->lastexception == OK );


    if ( (*error = serverFile->lastexception) != END_OF_FILE )
      {
        printf( "Error reading directory block #%d: %s\n", serverFile
		, ErrorString( *error ) );
	i = -2;
      }
    Close(serverFile);
    return( i );

  } /* ReadAndPrintDirectory */

