/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/

/*
 * Program to print V name descriptors.
 *
 * RJN -- 9/14/83
 */


#include <Vioprotocol.h>
#include <Vnaming.h>
#include <Vdirectory.h>

extern ArbitraryDescriptor *GetDescriptor();
extern PrintDescriptor();
static char *myName;

main(argc, argv)
    int argc;
    char **argv;
  {
    SystemCode Error;
    register ArbitraryDescriptor *desc;
    int bannertype;

    /*
     * Process command arguments.
     */

    myName = argv[0];
    argc--;
    argv++;
    if (argc == 0)
	argv[0] = "";
	
    bannertype = EMPTY_DESCRIPTOR;
    do
      {
	Error = OK;
	if ( (desc = GetDescriptor( *argv, &Error )) != NULL )
	  {
	    if ( PrintDescriptor( desc, &bannertype ) )
	      {
	        printf( "\n%s: unknown descriptor type %d.\n", *argv, 
				desc->e.descriptortype );
                bannertype = EMPTY_DESCRIPTOR;
	      }
	  }
	else
	        PrintError( Error, *argv );
	++argv;	
      }
    while ( --argc > 0 );

  } /* main */

ArbitraryDescriptor *GetDescriptor( name, error )
    char *name;
    SystemCode *error;
/*
 * Do a NREAD_DESCRIPTOR on "name" and return a pointer
 * to its descriptor.
 */
  {
    Message msg;
    register DescriptorRequest *req = (DescriptorRequest*)msg;
#define reply	((DescriptorReply*)req)

    /* save the name and descriptor in the same "segment" */
    static struct 
      { 
        ArbitraryDescriptor	entry;
				/* note this has to be longest name possible */
	char			name[ sizeof( ArbitraryDescriptor ) ];
      } Descriptor;
    
    strcpy( Descriptor.name, name );

    /* format the request */
    req->requestcode = NREAD_DESCRIPTOR;
    req->nameindex = ((int)&(Descriptor.name[ 0 ])) - (int)(&Descriptor);
    req->dataindex = 0;
    req->fileid = 0;	/* none */
    req->segmentptr = (char *)(&Descriptor);
    req->segmentlen = sizeof( Descriptor );

    /* route the request to the appropriate name server */
    Send( req, DirectToCurrentContext( req ) );

    if ( reply->replycode != OK )
      {
        *error = reply->replycode;	/* set the global error code */
	return( NULL );
      }
    
    return( &( Descriptor.entry ) );

  } /* GetDescriptor */    
