/************************************************************************/
/*									*/
/*			(C) COPYRIGHT 1983				*/
/*			BOARD OF TRUSTEES				*/
/*			LELAND STANDFORD JUNIOR UNIVERSITY		*/
/*			STANFORD, CA. 94305, U.S.A.			*/
/*									*/
/************************************************************************/


/*
 * telnet.c - IP User telnet package for use with the vgts.
 *
 * Marvin Theimer and Bill Nowicki December 1982
 *
 * Rewritten by Bill Nowicki April 1983 for stream package
 */


# include <Venviron.h>
# include <Vioprotocol.h>
# include <Vnet.h>
# include <Vgts.h>
# include <chars.h>
# include <ctype.h>

# define True 1
# define False 0

#define HelperStackSize 1000	/* 1000 works */
#define TimerStackSize 1000	/* 1000 works */


# define TelnetPort 23

/*
 * Telnet commands (byte values)
 */
#define SE 240
#define NOP 241
#define DM 242
#define Break 243
#define IP 244
#define AO 245
#define AYT 246
#define EC 247
#define EL 248
#define GA 249
#define SB 250
#define WILL 251
#define WONT 252
#define DO 253
#define DONT 254
#define IAC 255


/*
 * Telnet option codes.
 */
#define EchoOption 1
#define SuppressGaOption 3



Telnet(in,out, ihost)
    File *in, *out;
    char *ihost;
  {
	/*
	 * the main routine here, reads from file in and prints on file out,
	 * and handles one connection.
	 * When the connection is actually open, it starts up a helper to
	 * read from the keyboard.
	 */
     char host[128], buf[64];
     File *tcpInFile, *tcpOutFile, *OpenTcp();
     long addr;
     ProcessId helperPid;
     SystemCode error;
     register char c;
     int TelnetHelperProcess();
     int echoFlag = False;

     while (1)
       {
         SetVgtBanner(out,"iptn");
	 if (ihost == NULL)
	   {
	     fprintf(out,"\r\nWelcome to the Internet. Enter host name: ");
	     GetString(in,out,host);
	   }
	 else
	   {
	     strcpy(host, ihost);
	     ihost = NULL;
	   }
	 if (strlen(host)==0) continue;
	 addr = GetHostAddress(in,out,host);
	 if (addr==0) continue;
     	 helperPid = Create(20, TelnetHelperProcess, HelperStackSize);
	 if (helperPid == 0)
	    {
	      fprintf(out,
		     "Failed to create telnet helper process.\r\n");	      
	      continue;
  	    }
	tcpOutFile = OpenTcp(0, TelnetPort, addr, 1, DefaultTcpSecurity,
		DefaultTcpPrecedence, &error);
	if (tcpOutFile == NULL ||
	   (tcpInFile=OpenFile(tcpOutFile->fileserver,tcpOutFile->fileid+1,
	   	FREAD|FRELEASE_ON_CLOSE, &error)) == NULL )
	  {
	    fprintf(out,"Error: %s\r\n", ErrorString(error));
	    ReclaimResources(helperPid);
	    continue;
	   }
	Ready(helperPid, 4, in, out, tcpInFile, tcpOutFile);
	sprintf(buf,"iptn %s",host);
        SetVgtBanner(out,buf);
        while (True)
         {
	   c=getc(tcpInFile);
	   if ((tcpInFile->lastexception!=OK) &&
	           (tcpInFile->lastexception!=UrgentData))
	       break;
	   switch (c&255)
	     {
	        case IAC:
		    TelnetCommand(in,out,tcpInFile,tcpOutFile,&echoFlag);
		    break;

	     	default:
		    putc(c,out);
	            if (BufferEmpty(tcpInFile)) Flush(out);
	     }
	 }
	Flush(out);
        if (tcpInFile->lastexception != END_OF_FILE)
	  {
	    fprintf(out,"Close Error=%s\r\n",
	  	    ErrorString(tcpInFile->lastexception));
	  }
	SpecialClose(tcpOutFile, REL_STANDARD);
	SpecialClose(tcpInFile, REL_STANDARD);
	echoFlag = False;
	ReclaimResources(helperPid);
       }
  }


TelnetHelperProcess(in,out,tcpInFile, tcpOutFile)
    File *in, *out, *tcpInFile, *tcpOutFile;
  {
    /*
     * reads characters from the keyboard, and interprets the local
     * telnet commands
     */
     register char c;
     
     fprintf(out,"Open\r\n");
     Flush(out);
     
     while (True)
       {
         c = getc(in);
	 switch (c&255)
	   {
	    case TELNET_ESCAPE:
	      c = getc(in);
	      switch (c&255) 
		{
		  case 'c':
		  case 'e':
		    SpecialClose(tcpOutFile, REL_STANDARD);
		    SpecialClose(tcpInFile, REL_STANDARD);
				/* Note: when the internetserver returns
				   with END_OF_FILE the main telnet
				   process will destroy this process and
				   reclaim its stack. */
		    fprintf(out,"[Connection closed]\r\n");
		    Flush(out);
		    if ((c&255) == 'e')
		        ExitTelnet();
		    break;

		  case TELNET_ESCAPE:
		    putc(TELNET_ESCAPE, tcpOutFile);
		    break;

		  default:
	            putc(TELNET_ESCAPE,tcpOutFile);
	            putc(c,tcpOutFile);
		    break;
		}
	      break;
	    
	    case IAC:
	      putc(IAC,tcpOutFile);
	      putc(c,tcpOutFile);
	      break;
	      
	    default:
	      putc(c,tcpOutFile);
	      break;
	   }
         if (BufferEmpty(in))
	     Flush(tcpOutFile);
       }
  }



GetString(in,out,host)
    File *in, *out;
    char *host;
  {
  	/*
	 * read a string with appropriate echoing
	 */
    register char *p = host;
    char c;

    while (1)
      {
        Flush(out);
        c = getc(in);
	switch (c)
	  {
	    case CR:
	    case LF:
	        fprintf(out,"\r\n");
	        *p++ = 0;
		return;

	    case TELNET_ESCAPE:
	        c = getc(in);
	        switch (c) 
		 {
		  case 'e':
		    ExitTelnet();

		  default:
		    break;
		  }
	          break;

	    case BS:
	    case DEL:
	        if (p>host)
		  {
		    fprintf(out,"\b \b");
		    p--;
		  }
		break;

	    case NAK:
	        while (p>host)
		  {
		    fprintf(out,"\b \b");
		    p--;
		  }
		break;

	    default:
	        putc(c,out);
		*p++ = c;
		break;
	  }
      }
  }


TelnetCommand(in,out,tcpInFile,tcpOutFile,echoFlag)
    File *in, *out, *tcpInFile, *tcpOutFile;
    int *echoFlag;
  {
    /*
     * Handle the TCP Telnet commands (e.g. negotiate!)
     */
    register char c;
    
    c = getc(tcpInFile);
    switch (c&255)
      {
	case WILL:
	  c = getc(tcpInFile);
	  if (c==EchoOption)
	    {
	      if (*echoFlag) return;
	      *echoFlag = True;
	      putc(IAC,tcpOutFile);
	      putc(DO,tcpOutFile);
	    }
	  else
	    {
	      putc(IAC,tcpOutFile);
	      if (c==SuppressGaOption)
		putc(DO,tcpOutFile);
	      else
		putc(DONT,tcpOutFile);
	    }
	  putc(c,tcpOutFile);	    
	  break;

    	case WONT:
	  c = getc(tcpInFile);
	  fprintf(out,"Wont %d ",c&255);
	  break;

	case DO:
	  c = getc(tcpInFile);
	  putc(IAC,tcpOutFile);
	  putc(WONT,tcpOutFile);
	  putc(c,tcpOutFile);	    
	  break;

        case DONT:
	  c = getc(tcpInFile);
	  putc(IAC,tcpOutFile);
	  putc(WONT,tcpOutFile);
	  putc(c,tcpOutFile);	    
	  break;

        case IAC:
	  putc(IAC,out);
	  Flush(out);
	  break;

	case NOP:
	  break;

        default:
	  break;
      }
    Flush(tcpOutFile);
  }


ReclaimResources(pid)
    ProcessId pid;
  {
    Destroy(pid);
  }


ExitTelnet()
  {
    exit();
  }
